/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.implementation.pojo.builder.ArrayBuilder;
import org.fabric3.implementation.pojo.builder.CollectionBuilder;
import org.fabric3.implementation.pojo.builder.MapBuilder;
import org.fabric3.implementation.pojo.builder.ObjectBuilder;
import org.fabric3.implementation.pojo.builder.PropertySupplierBuilder;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;

public class PropertySupplierBuilderImpl
implements PropertySupplierBuilder {
    private ArrayBuilder arrayBuilder;
    private CollectionBuilder collectionBuilder;
    private MapBuilder mapBuilder;
    private ObjectBuilder objectBuilder;

    public PropertySupplierBuilderImpl(@Reference ArrayBuilder arrayBuilder, @Reference CollectionBuilder collectionBuilder, @Reference MapBuilder mapBuilder, @Reference ObjectBuilder objectBuilder) {
        this.arrayBuilder = arrayBuilder;
        this.collectionBuilder = collectionBuilder;
        this.mapBuilder = mapBuilder;
        this.objectBuilder = objectBuilder;
    }

    @Override
    public Supplier<?> createSupplier(String name, DataType dataType, Document value, boolean many, ClassLoader classLoader) {
        Class<?> type = dataType.getType();
        if (type.isArray()) {
            return this.arrayBuilder.createSupplier(name, dataType, value, classLoader);
        }
        if (Map.class.equals(type)) {
            return this.mapBuilder.createSupplier(name, (JavaGenericType)dataType, value, classLoader);
        }
        if (List.class.equals(type)) {
            return this.collectionBuilder.createSupplier(new ArrayList(), name, (JavaGenericType)dataType, value, classLoader);
        }
        if (Set.class.equals(type)) {
            return this.collectionBuilder.createSupplier(new HashSet(), name, (JavaGenericType)dataType, value, classLoader);
        }
        if (LinkedList.class.equals(type)) {
            return this.collectionBuilder.createSupplier(new LinkedList(), name, (JavaGenericType)dataType, value, classLoader);
        }
        return this.objectBuilder.createSupplier(name, dataType, value, classLoader);
    }
}

