/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.component;

import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.pojo.manager.ImplementationManager;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.injection.InjectionAttributes;

public abstract class PojoComponent
implements ScopedComponent {
    private URI uri;
    private ImplementationManagerFactory factory;
    private ScopeContainer scopeContainer;
    private boolean eager;
    private ImplementationManager implementationManager;
    private URI contributionUri;
    private MonitorLevel level = MonitorLevel.INFO;
    private AtomicBoolean recreate = new AtomicBoolean(true);
    private Object cachedInstance;

    public PojoComponent(URI componentId, ImplementationManagerFactory factory, ScopeContainer scopeContainer, boolean eager, URI contributionUri) {
        this.uri = componentId;
        this.factory = factory;
        this.scopeContainer = scopeContainer;
        this.eager = eager;
        this.contributionUri = contributionUri;
    }

    @Override
    public void start() throws Fabric3Exception {
        this.scopeContainer.register(this);
    }

    @Override
    public void stop() throws Fabric3Exception {
        this.implementationManager = null;
        this.cachedInstance = null;
        this.scopeContainer.unregister(this);
    }

    @Override
    public void startUpdate() {
        this.factory.startUpdate();
    }

    @Override
    public void endUpdate() {
        this.factory.endUpdate();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public URI getContributionUri() {
        return this.contributionUri;
    }

    @Override
    public String getName() {
        return this.uri.toString();
    }

    @Override
    public MonitorLevel getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    @Override
    public boolean isEagerInit() {
        return this.eager;
    }

    @Override
    public Object getInstance() throws Fabric3Exception {
        if (this.cachedInstance != null) {
            return this.cachedInstance;
        }
        return this.scopeContainer.getInstance(this);
    }

    @Override
    public void releaseInstance(Object instance) throws Fabric3Exception {
        this.scopeContainer.releaseInstance(this, instance);
    }

    @Override
    public Object createInstance() throws Fabric3Exception {
        if (this.recreate.getAndSet(false)) {
            this.implementationManager = null;
        }
        Object instance = this.getImplementationManager().newInstance();
        if (Scope.COMPOSITE == this.scopeContainer.getScope()) {
            this.cachedInstance = instance;
        }
        return instance;
    }

    @Override
    public Supplier<Object> createSupplier() {
        return this::getInstance;
    }

    @Override
    public void startInstance(Object instance) throws Fabric3Exception {
        this.getImplementationManager().start(instance);
    }

    @Override
    public void stopInstance(Object instance) throws Fabric3Exception {
        this.cachedInstance = null;
        this.getImplementationManager().stop(instance);
    }

    @Override
    public void reinject(Object instance) throws Fabric3Exception {
        this.getImplementationManager().reinject(instance);
    }

    public ScopeContainer getScopeContainer() {
        return this.scopeContainer;
    }

    public Class<?> getImplementationClass() {
        return this.factory.getImplementationClass();
    }

    public void setSupplier(Injectable injectable, Supplier<?> supplier) {
        this.setSupplier(injectable, supplier, InjectionAttributes.EMPTY_ATTRIBUTES);
    }

    public void setSupplier(Injectable injectable, Supplier<?> supplier, InjectionAttributes attributes) {
        this.factory.setSupplier(injectable, supplier, attributes);
        List<Object> instances = this.scopeContainer.getActiveInstances(this);
        String name = injectable.getName();
        for (Object instance : instances) {
            this.getImplementationManager().updated(instance, name);
        }
        this.recreate.set(true);
    }

    public void removeSupplier(Injectable injectable) {
        this.factory.removeSupplier(injectable);
        String name = injectable.getName();
        List<Object> instances = this.scopeContainer.getActiveInstances(this);
        for (Object instance : instances) {
            this.getImplementationManager().removed(instance, name);
        }
        this.recreate.set(true);
    }

    public Supplier<?> getSupplier(Injectable injectable) {
        return this.factory.getObjectSupplier(injectable);
    }

    public String toString() {
        return "[" + this.uri.toString() + "] in state [" + super.toString() + ']';
    }

    private ImplementationManager getImplementationManager() {
        if (this.implementationManager == null) {
            this.implementationManager = this.factory.createManager();
        }
        return this.implementationManager;
    }
}

