/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.generator;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.pojo.provision.PhysicalPojoComponent;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.fabric3.spi.model.physical.PhysicalProperty;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.w3c.dom.Document;

public class GenerationHelperImpl
implements GenerationHelper {
    @Override
    public void processInjectionSites(InjectingComponentType componentType, ImplementationManagerDefinition managerDefinition) {
        Map<InjectionSite, Injectable> mappings = componentType.getInjectionSites();
        Map<InjectionSite, Injectable> construction = managerDefinition.getConstruction();
        Constructor<?> constructor = componentType.getConstructor();
        HashSet<Injectable> byConstruction = new HashSet<Injectable>();
        if (constructor != null) {
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, i);
                Injectable attribute = mappings.get(site);
                construction.put(site, attribute);
                byConstruction.add(attribute);
            }
        }
        Map<InjectionSite, Injectable> postConstruction = managerDefinition.getPostConstruction();
        Map<InjectionSite, Injectable> reinjection = managerDefinition.getReinjectables();
        for (Map.Entry<InjectionSite, Injectable> entry : mappings.entrySet()) {
            InjectionSite site = entry.getKey();
            if (site instanceof ConstructorInjectionSite) continue;
            Injectable attribute = entry.getValue();
            if (!byConstruction.contains(attribute)) {
                postConstruction.put(site, attribute);
            }
            reinjection.put(site, attribute);
        }
    }

    @Override
    public void processPropertyValues(LogicalComponent<?> component, PhysicalPojoComponent pojoComponent) {
        for (LogicalProperty property : component.getAllProperties().values()) {
            PhysicalProperty physicalProperty;
            String name = property.getName();
            boolean many = property.isMany();
            boolean required = property.isRequired();
            if (property.getKey() != null) {
                PhysicalProperty physicalProperty2 = PhysicalProperty.Builder.newBuilder(name).key(property.getKey()).required(required).many(many).build();
                pojoComponent.setProperty(physicalProperty2);
                continue;
            }
            if (property.getXmlValue() != null) {
                Document document = property.getXmlValue();
                physicalProperty = PhysicalProperty.Builder.newBuilder(name).xmlValue(document).required(required).many(many).build();
                pojoComponent.setProperty(physicalProperty);
                continue;
            }
            if (property.getInstanceValue() == null) continue;
            Object value = property.getInstanceValue();
            physicalProperty = PhysicalProperty.Builder.newBuilder(name).instanceValue(value).required(required).many(many).build();
            pojoComponent.setProperty(physicalProperty);
        }
    }
}

