/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryImpl;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ImplementationManagerFactoryBuilderImpl
implements ImplementationManagerFactoryBuilder {
    private ReflectionFactory reflectionFactory;
    private ClassLoaderRegistry classLoaderRegistry;

    public ImplementationManagerFactoryBuilderImpl(@Reference ReflectionFactory reflectionFactory, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.reflectionFactory = reflectionFactory;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public ImplementationManagerFactoryImpl build(ImplementationManagerDefinition definition) throws Fabric3Exception {
        Constructor<?> ctr = definition.getConstructor();
        Map<InjectionSite, Injectable> injectionSites = definition.getConstruction();
        Injectable[] cdiSources = new Injectable[ctr.getParameterTypes().length];
        for (Map.Entry<InjectionSite, Injectable> entry : injectionSites.entrySet()) {
            InjectionSite site = entry.getKey();
            Injectable injectable = entry.getValue();
            ConstructorInjectionSite constructorSite = (ConstructorInjectionSite)site;
            cdiSources[constructorSite.getParam()] = injectable;
        }
        for (int i = 0; i < cdiSources.length; ++i) {
            if (cdiSources[i] != null) continue;
            String clazz = ctr.getName();
            throw new Fabric3Exception("No injection value for constructor parameter " + i + " in class " + clazz);
        }
        LifecycleInvoker initInvoker = this.getInitInvoker(definition);
        LifecycleInvoker destroyInvoker = this.getDestroyInvoker(definition);
        Map<InjectionSite, Injectable> postConstruction = definition.getPostConstruction();
        List<Injectable> construction = Arrays.asList(cdiSources);
        boolean reinjectable = definition.isReinjectable();
        ClassLoader cl = this.classLoaderRegistry.getClassLoader(definition.getClassLoaderUri());
        return new ImplementationManagerFactoryImpl(ctr, construction, postConstruction, initInvoker, destroyInvoker, reinjectable, cl, this.reflectionFactory);
    }

    private LifecycleInvoker getInitInvoker(ImplementationManagerDefinition definition) {
        LifecycleInvoker initInvoker = null;
        Method initMethod = definition.getInitMethod();
        if (initMethod != null) {
            initInvoker = this.reflectionFactory.createLifecycleInvoker(initMethod);
        }
        return initInvoker;
    }

    private LifecycleInvoker getDestroyInvoker(ImplementationManagerDefinition definition) {
        LifecycleInvoker destroyInvoker = null;
        Method destroyMethod = definition.getDestroyMethod();
        if (destroyMethod != null) {
            destroyInvoker = this.reflectionFactory.createLifecycleInvoker(destroyMethod);
        }
        return destroyInvoker;
    }
}

