/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import org.fabric3.implementation.pojo.spi.reflection.ConsumerInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ConsumerInvokerFactory;
import org.fabric3.implementation.pojo.spi.reflection.InjectorFactory;
import org.fabric3.implementation.pojo.spi.reflection.InstantiatorFactory;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvokerFactory;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvokerFactory;
import org.fabric3.spi.container.injection.Injector;
import org.oasisopen.sca.annotation.Reference;

public class ReflectionFactoryImpl
implements ReflectionFactory {
    private InstantiatorFactory instantiatorFactory;
    private InjectorFactory injectorFactory;
    private LifecycleInvokerFactory lifecycleInvokerFactory;
    private ServiceInvokerFactory serviceInvokerFactory;
    private ConsumerInvokerFactory consumerInvokerFactory;

    public ReflectionFactoryImpl(@Reference InstantiatorFactory instantiatorFactory, @Reference InjectorFactory injectorFactory, @Reference LifecycleInvokerFactory lifecycleInvokerFactory, @Reference ServiceInvokerFactory serviceInvokerFactory, @Reference ConsumerInvokerFactory consumerInvokerFactory) {
        this.instantiatorFactory = instantiatorFactory;
        this.injectorFactory = injectorFactory;
        this.lifecycleInvokerFactory = lifecycleInvokerFactory;
        this.serviceInvokerFactory = serviceInvokerFactory;
        this.consumerInvokerFactory = consumerInvokerFactory;
    }

    @Reference(required=false)
    public void setInstantiatorFactories(List<InstantiatorFactory> factories) {
        factories.stream().filter(factory -> !factory.isDefault() || this.instantiatorFactory == null).forEach(factory -> {
            this.instantiatorFactory = factory;
        });
    }

    @Reference(required=false)
    public void setInjectorFactories(List<InjectorFactory> factories) {
        factories.stream().filter(factory -> !factory.isDefault() || this.injectorFactory == null).forEach(factory -> {
            this.injectorFactory = factory;
        });
    }

    @Reference(required=false)
    public void setLifecycleInvokerFactories(List<LifecycleInvokerFactory> factories) {
        factories.stream().filter(factory -> !factory.isDefault() || this.lifecycleInvokerFactory == null).forEach(factory -> {
            this.lifecycleInvokerFactory = factory;
        });
    }

    @Reference(required=false)
    public void setServiceInvokerFactories(List<ServiceInvokerFactory> factories) {
        factories.stream().filter(factory -> !factory.isDefault() || this.serviceInvokerFactory == null).forEach(factory -> {
            this.serviceInvokerFactory = factory;
        });
    }

    @Reference(required=false)
    public void setConsumerInvokerFactories(List<ConsumerInvokerFactory> factories) {
        factories.stream().filter(factory -> !factory.isDefault() || this.serviceInvokerFactory == null).forEach(factory -> {
            this.consumerInvokerFactory = factory;
        });
    }

    @Override
    public Supplier<?> createInstantiator(Constructor<?> constructor, Supplier<?>[] suppliers) {
        return this.instantiatorFactory.createInstantiator(constructor, suppliers);
    }

    @Override
    public Injector<?> createInjector(Member member, Supplier<?> supplier) {
        return this.injectorFactory.createInjector(member, supplier);
    }

    @Override
    public LifecycleInvoker createLifecycleInvoker(Method method) {
        return this.lifecycleInvokerFactory.createLifecycleInvoker(method);
    }

    @Override
    public ServiceInvoker createServiceInvoker(Method method) {
        return this.serviceInvokerFactory.createInvoker(method);
    }

    @Override
    public ConsumerInvoker createConsumerInvoker(Method method) {
        return this.consumerInvokerFactory.createInvoker(method);
    }
}

