/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.supplier;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.pojo.supplier.FactoryState;
import org.fabric3.implementation.pojo.supplier.MultiplicitySupplier;
import org.fabric3.spi.container.injection.InjectionAttributes;

public class MapMultiplicitySupplier
implements MultiplicitySupplier<Map<?, ?>> {
    private volatile Map<Object, Supplier<?>> suppliers = new HashMap();
    private Map<Object, Supplier<?>> temporarySuppliers;
    private FactoryState state = FactoryState.UPDATED;

    @Override
    public Map<Object, Object> get() throws Fabric3Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<Object, Supplier<?>> entry : this.suppliers.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    @Override
    public void addSupplier(Supplier<?> supplier, InjectionAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes was null");
        }
        if (attributes.getKey() == null) {
            throw new IllegalArgumentException("Attributes was null");
        }
        if (this.state != FactoryState.UPDATING) {
            throw new IllegalStateException("Factory not in updating state. The method startUpdate() must be called first.");
        }
        this.temporarySuppliers.put(attributes.getKey(), supplier);
    }

    @Override
    public void clear() {
        this.suppliers.clear();
    }

    @Override
    public void startUpdate() {
        this.state = FactoryState.UPDATING;
        this.temporarySuppliers = new HashMap();
    }

    @Override
    public void endUpdate() {
        if (this.temporarySuppliers != null && !this.temporarySuppliers.isEmpty()) {
            this.suppliers = this.temporarySuppliers;
            this.temporarySuppliers = null;
        }
        this.state = FactoryState.UPDATED;
    }
}

