/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.reflection.jdk;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.pojo.supplier.MultiplicitySupplier;
import org.fabric3.spi.container.injection.InjectionAttributes;
import org.fabric3.spi.container.injection.Injector;

public class FieldInjector
implements Injector<Object> {
    private final Field field;
    private Supplier<?> supplier;

    public FieldInjector(Field field, Supplier<?> supplier) {
        this.field = field;
        this.field.setAccessible(true);
        this.supplier = supplier;
    }

    @Override
    public void inject(Object instance) throws Fabric3Exception {
        try {
            Object target;
            if (this.supplier == null) {
                target = null;
            } else {
                target = this.supplier.get();
                if (target == null) {
                    return;
                }
            }
            this.field.set(instance, target);
        }
        catch (IllegalAccessException e) {
            String id = this.field.getName();
            throw new AssertionError((Object)("Field is not accessible:" + id));
        }
    }

    @Override
    public void setSupplier(Supplier<?> newSupplier, InjectionAttributes attributes) {
        if (this.supplier instanceof MultiplicitySupplier) {
            ((MultiplicitySupplier)this.supplier).addSupplier(newSupplier, attributes);
        } else {
            this.supplier = newSupplier;
        }
    }

    @Override
    public void clearSupplier() {
        if (this.supplier instanceof MultiplicitySupplier) {
            ((MultiplicitySupplier)this.supplier).clear();
        } else {
            this.supplier = null;
        }
    }
}

