/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.reflection.jdk;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.pojo.supplier.MultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.UpdatableSupplier;
import org.fabric3.spi.container.injection.InjectionAttributes;
import org.fabric3.spi.container.injection.Injector;

public class MethodInjector
implements Injector<Object> {
    private final Method method;
    private Supplier<?> supplier;

    public MethodInjector(Method method, Supplier<?> supplier) {
        assert (method != null);
        assert (supplier != null);
        this.method = method;
        this.method.setAccessible(true);
        this.supplier = supplier;
    }

    @Override
    public void inject(Object instance) throws Fabric3Exception {
        Object target;
        if (this.supplier == null) {
            target = null;
        } else {
            target = this.supplier.get();
            if (target == null && !(this.supplier instanceof UpdatableSupplier)) {
                return;
            }
        }
        try {
            this.method.invoke(instance, target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            String id = this.method.toString();
            throw new Fabric3Exception("Exception thrown by setter: " + id, e);
        }
        catch (InvocationTargetException e) {
            String id = this.method.toString();
            throw new Fabric3Exception("Exception thrown by setter: " + id, e.getCause());
        }
    }

    @Override
    public void setSupplier(Supplier<?> newSupplier, InjectionAttributes attributes) {
        if (this.supplier instanceof MultiplicitySupplier) {
            ((MultiplicitySupplier)this.supplier).addSupplier(newSupplier, attributes);
        } else {
            this.supplier = newSupplier;
        }
    }

    @Override
    public void clearSupplier() {
        if (this.supplier instanceof MultiplicitySupplier) {
            ((MultiplicitySupplier)this.supplier).clear();
        } else {
            this.supplier = null;
        }
    }
}

