/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.reflection.jdk;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;

public class MethodLifecycleInvoker
implements LifecycleInvoker {
    private Method method;

    public MethodLifecycleInvoker(Method method) {
        assert (method != null);
        this.method = method;
        this.method.setAccessible(true);
    }

    @Override
    public void invoke(Object instance) {
        try {
            this.method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            String signature = this.getSignature();
            throw new Fabric3Exception("Invalid arguments provided when invoking method: " + signature, e.getCause());
        }
        catch (IllegalAccessException e) {
            String signature = this.getSignature();
            throw new Fabric3Exception("Method is not accessible: " + signature);
        }
        catch (InvocationTargetException e) {
            String signature = this.getSignature();
            throw new Fabric3Exception("Exception thrown when invoking method: " + signature, e.getCause());
        }
    }

    private String getSignature() {
        String name = this.method.getName();
        return this.method.getDeclaringClass().getName() + "." + name + "()";
    }
}

