/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.oasisopen.sca.annotation.Reference;

public class SystemHeuristic
implements HeuristicProcessor {
    private final HeuristicProcessor serviceHeuristic;
    private final HeuristicProcessor constructorHeuristic;
    private final HeuristicProcessor injectionHeuristic;

    public SystemHeuristic(@Reference(name="service") HeuristicProcessor serviceHeuristic, @Reference(name="constructor") HeuristicProcessor constructorHeuristic, @Reference(name="injection") HeuristicProcessor injectionHeuristic) {
        this.serviceHeuristic = serviceHeuristic;
        this.constructorHeuristic = constructorHeuristic;
        this.injectionHeuristic = injectionHeuristic;
    }

    @Override
    public void applyHeuristics(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        this.serviceHeuristic.applyHeuristics(componentType, implClass, context);
        this.constructorHeuristic.applyHeuristics(componentType, implClass, context);
        this.injectionHeuristic.applyHeuristics(componentType, implClass, context);
    }
}

