/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationRuntimeException;

public class SystemInvokerInterceptor
implements Interceptor {
    private final Method operation;
    private final AtomicComponent component;

    public SystemInvokerInterceptor(Method operation, AtomicComponent component) {
        this.operation = operation;
        this.component = component;
    }

    @Override
    public void setNext(Interceptor next) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interceptor getNext() {
        return null;
    }

    @Override
    public Message invoke(Message msg) {
        Object instance;
        Object body = msg.getBody();
        try {
            instance = this.component.getInstance();
        }
        catch (Fabric3Exception e) {
            throw new InvocationRuntimeException(e);
        }
        try {
            msg.setBody(this.operation.invoke(instance, (Object[])body));
        }
        catch (InvocationTargetException e) {
            msg.setBodyWithFault(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new InvocationRuntimeException(e);
        }
        finally {
            try {
                this.component.releaseInstance(instance);
            }
            catch (Fabric3Exception e) {
                throw new InvocationRuntimeException(e);
            }
        }
        return msg;
    }
}

