/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.pojo.spi.proxy.ChannelProxyService;
import org.fabric3.implementation.system.provision.SystemConnectionSource;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.builder.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemSourceConnectionAttacher
implements SourceConnectionAttacher<SystemConnectionSource> {
    private ComponentManager manager;
    private ChannelProxyService proxyService;

    @Reference(required=false)
    public void setProxyService(List<ChannelProxyService> proxyServices) {
        this.proxyService = !proxyServices.isEmpty() ? proxyServices.get(0) : null;
    }

    public SystemSourceConnectionAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
    }

    @Override
    public void attach(SystemConnectionSource source, PhysicalConnectionTarget target, ChannelConnection connection) {
        URI sourceUri = source.getUri();
        URI sourceName = UriHelper.getDefragmentedName(sourceUri);
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        Class<?> type = source.getServiceInterface();
        Supplier<Object> supplier = source.isDirectConnection() ? connection.getDirectConnection().get() : this.proxyService.createSupplier(type, connection);
        component.setSupplier(injectable, supplier);
    }

    @Override
    public void detach(SystemConnectionSource source, PhysicalConnectionTarget target) throws Fabric3Exception {
        URI sourceName = UriHelper.getDefragmentedName(source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeSupplier(injectable);
    }
}

