/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.singleton;

import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.implementation.system.singleton.SingletonImplementation;
import org.fabric3.implementation.system.singleton.SingletonWireSource;
import org.fabric3.implementation.system.singleton.SingletonWireTarget;
import org.fabric3.spi.domain.generator.ComponentGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.physical.PhysicalComponent;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class SingletonComponentGenerator
implements ComponentGenerator<LogicalComponent<SingletonImplementation>> {
    @Override
    public PhysicalComponent generate(LogicalComponent<SingletonImplementation> component) throws Fabric3Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhysicalWireSource generateSource(LogicalReference reference) throws Fabric3Exception {
        SingletonWireSource source = new SingletonWireSource();
        URI uri = reference.getUri();
        source.setOptimizable(true);
        source.setUri(uri);
        source.setInjectable(new Injectable(InjectableType.REFERENCE, uri.getFragment()));
        return source;
    }

    @Override
    public PhysicalWireTarget generateTarget(LogicalService service) throws Fabric3Exception {
        SingletonWireTarget target = new SingletonWireTarget();
        URI uri = service.getUri();
        target.setUri(uri);
        target.setOptimizable(true);
        return target;
    }

    @Override
    public PhysicalWireSource generateResourceSource(LogicalResourceReference<?> resourceReference) throws Fabric3Exception {
        SingletonWireSource source = new SingletonWireSource();
        URI uri = resourceReference.getUri();
        source.setOptimizable(true);
        source.setUri(uri);
        source.setInjectable(new Injectable(InjectableType.RESOURCE, uri.getFragment()));
        return source;
    }

    @Override
    public PhysicalConnectionSource generateConnectionSource(LogicalProducer producer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhysicalConnectionTarget generateConnectionTarget(LogicalConsumer consumer) throws Fabric3Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhysicalWireSource generateCallbackSource(LogicalService service) throws Fabric3Exception {
        throw new UnsupportedOperationException();
    }
}

