/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.api.annotation.model.Implementation;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.introspection.java.UnknownImplementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ComponentAnnotationMapper;
import org.fabric3.spi.introspection.java.ComponentProcessor;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.oasisopen.sca.annotation.Reference;

public class ComponentProcessorImpl
implements ComponentProcessor {
    private Map<String, ImplementationProcessor<?>> implementationProcessors = Collections.emptyMap();
    private List<ComponentAnnotationMapper> mappers = new ArrayList<ComponentAnnotationMapper>();

    @Reference(required=false)
    public void setImplementationProcessors(Map<String, ImplementationProcessor<?>> implementationProcessors) {
        this.implementationProcessors = implementationProcessors;
    }

    @Reference(required=false)
    public void setMappers(List<ComponentAnnotationMapper> mappers) {
        this.mappers = mappers;
    }

    @Override
    public void process(Component<?> component, IntrospectionContext context) {
        String type = ((org.fabric3.api.model.type.component.Implementation)component.getImplementation()).getType();
        ImplementationProcessor<?> processor = this.implementationProcessors.get(type);
        if (processor == null) {
            context.addError(new UnknownImplementation("Unknown implementation type: " + type));
            return;
        }
        processor.process(component, context);
    }

    @Override
    public void process(Component<?> component, Class clazz, IntrospectionContext context) {
        ImplementationProcessor<?> processor;
        String implementationType = "java";
        block0: for (Annotation annotation : clazz.getAnnotations()) {
            Implementation implementation = annotation.annotationType().getAnnotation(Implementation.class);
            if (implementation != null) {
                implementationType = implementation.value();
                break;
            }
            for (ComponentAnnotationMapper mapper : this.mappers) {
                String alias = mapper.getImplementationType(annotation);
                if (alias == null) continue;
                implementationType = alias;
                continue block0;
            }
        }
        if ((processor = this.implementationProcessors.get(implementationType)) == null) {
            context.addError(new UnknownImplementation("Unknown implementation type: " + implementationType));
            return;
        }
        processor.process(component, clazz, context);
    }
}

