/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.fabric3.api.model.type.component.Callback;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.introspection.java.annotation.InvalidAccessor;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Reference;

public class OASISCallbackProcessor
extends AbstractAnnotationProcessor<org.oasisopen.sca.annotation.Callback> {
    private final IntrospectionHelper helper;
    private final JavaContractProcessor contractProcessor;

    public OASISCallbackProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(org.oasisopen.sca.annotation.Callback.class);
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    @Override
    public void visitField(org.oasisopen.sca.annotation.Callback annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        this.validate(field, componentType, context);
        String name = this.helper.getSiteName(field, null);
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        Callback definition = this.createDefinition(name, type, implClass, componentType, context);
        componentType.add(definition, (InjectionSite)site);
    }

    @Override
    public void visitMethod(org.oasisopen.sca.annotation.Callback annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        this.validate(method, componentType, context);
        String name = this.helper.getSiteName(method, null);
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        Callback definition = this.createDefinition(name, type, implClass, componentType, context);
        componentType.add(definition, (InjectionSite)site);
    }

    private void validate(Field field, InjectingComponentType componentType, IntrospectionContext context) {
        if (!Modifier.isProtected(field.getModifiers()) && !Modifier.isPublic(field.getModifiers())) {
            Class<?> clazz = field.getDeclaringClass();
            InvalidAccessor warning = new InvalidAccessor("Illegal callback. The field " + field.getName() + " on " + clazz.getName() + " is annotated with @Callback and must be public or protected.", field, componentType);
            context.addError(warning);
        }
    }

    private void validate(Method method, InjectingComponentType componentType, IntrospectionContext context) {
        if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers())) {
            InvalidAccessor warning = new InvalidAccessor("Illegal callback. The method " + method + " is annotated with @Callback and must be public or protected.", method, componentType);
            context.addError(warning);
        }
    }

    private Callback createDefinition(String name, Type type, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class<?> baseType = this.helper.getBaseType(type, typeMapping);
        JavaServiceContract contract = this.contractProcessor.introspect(baseType, implClass, context, componentType);
        return new Callback(name, contract);
    }
}

