/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.policy.OperationPolicyIntrospector;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

public class OASISServiceProcessor
extends AbstractAnnotationProcessor<Service> {
    private final JavaContractProcessor contractProcessor;
    private OperationPolicyIntrospector policyIntrospector;

    public OASISServiceProcessor(JavaContractProcessor contractProcessor) {
        super(Service.class);
        this.contractProcessor = contractProcessor;
    }

    @Constructor
    public OASISServiceProcessor(@Reference JavaContractProcessor contractProcessor, @Reference OperationPolicyIntrospector policyIntrospector) {
        super(Service.class);
        this.contractProcessor = contractProcessor;
        this.policyIntrospector = policyIntrospector;
    }

    @Override
    public void visitType(Service annotation, Class<?> type, InjectingComponentType componentType, IntrospectionContext context) {
        Class<?>[] services = annotation.value();
        String[] names = annotation.names();
        for (int i = 0; i < services.length; ++i) {
            Class<?> service = services[i];
            componentType.add(this.createDefinition(service, names.length == 0 ? service.getSimpleName() : names[i], type, componentType, context));
        }
    }

    private org.fabric3.api.model.type.component.Service createDefinition(Class<?> service, String name, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        JavaServiceContract serviceContract = this.contractProcessor.introspect(service, implClass, context, componentType);
        org.fabric3.api.model.type.component.Service definition = new org.fabric3.api.model.type.component.Service(name, serviceContract);
        if (this.policyIntrospector != null) {
            this.policyIntrospector.introspectPolicyOnOperations(serviceContract, implClass, context);
        }
        return definition;
    }
}

