/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.IntentMetaData;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.oasisopen.sca.annotation.Intent;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Qualifier;
import org.oasisopen.sca.annotation.Requires;

public class PolicyAnnotationProcessorImpl
implements PolicyAnnotationProcessor {
    @Override
    public void process(Annotation annotation, PolicyAware modelObject, IntrospectionContext context) {
        if (!(annotation instanceof Requires) && !(annotation instanceof PolicySets)) {
            this.processIntentAnnotation(annotation, modelObject, context);
        }
    }

    private void processIntentAnnotation(Annotation annotation, PolicyAware modelObject, IntrospectionContext context) {
        Class<? extends Annotation> annotClass = annotation.annotationType();
        try {
            if (annotClass.isAnnotationPresent(Intent.class)) {
                Intent intent = annotClass.getAnnotation(Intent.class);
                String val = intent.value();
                String[] qualifiers = this.getMetadataValue(annotation, Qualifier.class, context);
                QName name = null;
                if (qualifiers == null || qualifiers.length < 1 || qualifiers[0].length() < 1) {
                    name = QName.valueOf(val);
                } else {
                    for (String qualifier : qualifiers) {
                        name = QName.valueOf(qualifier);
                    }
                }
                if (modelObject instanceof ComponentType) {
                    modelObject.addPolicy(name.getLocalPart());
                } else if (modelObject instanceof Operation) {
                    Operation operation = (Operation)modelObject;
                    operation.addPolicy(name.getLocalPart());
                    String[] metadata = this.getMetadataValue(annotation, IntentMetaData.class, context);
                    if (metadata != null && metadata.length >= 1 && metadata[0].length() >= 1) {
                        operation.addMetadata(name, (Serializable)metadata);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            context.addError(new InvalidAnnotation("Error reading annotation value ", annotClass, annotation, annotClass, e));
        }
        catch (IllegalAccessException e) {
            context.addError(new InvalidAnnotation("Error reading annotation value " + annotClass.getName(), annotClass, annotation, annotClass, e));
        }
        catch (InvocationTargetException e) {
            context.addError(new InvalidAnnotation("Error reading annotation value" + annotClass.getName(), annotClass, annotation, annotClass, e));
        }
    }

    private String[] getMetadataValue(Annotation annotation, Class<? extends Annotation> metadataAnnotClass, IntrospectionContext context) throws IllegalAccessException, InvocationTargetException {
        Class<? extends Annotation> annotClass = annotation.annotationType();
        for (Method method : annotClass.getMethods()) {
            if (!method.isAnnotationPresent(metadataAnnotClass)) continue;
            Class<?> type = method.getReturnType();
            if (type.isArray() && String.class.equals(type.getComponentType())) {
                return (String[])method.invoke((Object)annotation, new Object[0]);
            }
            if (String.class.equals(type)) {
                String ret = (String)method.invoke((Object)annotation, new Object[0]);
                return new String[]{ret};
            }
            String metadataName = metadataAnnotClass.getName();
            String annotationName = annotClass.getName();
            InvalidAnnotation error = new InvalidAnnotation("Value for " + metadataName + " must be String or String[] on " + annotationName, annotClass, annotation, annotClass);
            context.addError(error);
        }
        return null;
    }
}

