/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.introspection.java.annotation.InvalidProducerInterface;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ProducerProcessor
extends AbstractAnnotationProcessor<org.fabric3.api.annotation.Producer> {
    private JavaContractProcessor contractProcessor;
    private IntrospectionHelper helper;

    public ProducerProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(org.fabric3.api.annotation.Producer.class);
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    @Override
    public void visitField(org.fabric3.api.annotation.Producer annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(field, annotation.value());
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        Producer<ComponentType> producer = this.createProducer(name, type, implClass, componentType, field, context);
        Class<?> clazz = field.getDeclaringClass();
        this.processTargets(annotation, producer, field, clazz, context);
        componentType.add(producer, (InjectionSite)site);
    }

    @Override
    public void visitMethod(org.fabric3.api.annotation.Producer annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(method, annotation.value());
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        Producer<ComponentType> definition = this.createProducer(name, type, implClass, componentType, method, context);
        Class<?> clazz = method.getDeclaringClass();
        this.processTargets(annotation, definition, method, clazz, context);
        componentType.add(definition, (InjectionSite)site);
    }

    @Override
    public void visitConstructorParameter(org.fabric3.api.annotation.Producer annotation, Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, annotation.value());
        Type type = this.helper.getGenericType(constructor, index);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        Producer<ComponentType> producer = this.createProducer(name, type, implClass, componentType, constructor, context);
        Class<?> clazz = constructor.getDeclaringClass();
        this.processTargets(annotation, producer, constructor, clazz, context);
        componentType.add(producer, (InjectionSite)site);
    }

    private Producer<ComponentType> createProducer(String name, Type type, Class<?> implClass, InjectingComponentType componentType, Member member, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class<?> baseType = this.helper.getBaseType(type, typeMapping);
        JavaServiceContract contract = this.contractProcessor.introspect(baseType, implClass, context, componentType);
        if (contract.getOperations().isEmpty()) {
            String interfaceName = contract.getInterfaceName();
            InvalidProducerInterface error = new InvalidProducerInterface("Producer interfaces must have at least one method: " + interfaceName, member, componentType);
            context.addError(error);
        }
        return new Producer<ComponentType>(name, contract);
    }

    private void processTargets(org.fabric3.api.annotation.Producer annotation, Producer producer, AnnotatedElement element, Class<?> clazz, IntrospectionContext context) {
        try {
            if (annotation.targets().length > 0) {
                for (String target : annotation.targets()) {
                    producer.addTarget(new URI(target));
                }
            } else if (annotation.target().length() > 0) {
                producer.addTarget(new URI(annotation.target()));
            }
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid producer target on : " + clazz.getName(), element, annotation, clazz, e);
            context.addError(error);
        }
    }
}

