/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.contract;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.introspection.java.contract.InvalidCallbackContract;
import org.fabric3.introspection.java.contract.MissingCallback;
import org.fabric3.introspection.java.contract.OverloadedOperation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.InterfaceIntrospector;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.contract.TypeIntrospector;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.OneWay;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Remotable;

public class JavaContractProcessorImpl
implements JavaContractProcessor {
    private final IntrospectionHelper helper;
    private List<InterfaceIntrospector> interfaceIntrospectors;
    private List<TypeIntrospector> typeIntrospectors;

    public JavaContractProcessorImpl(@Reference IntrospectionHelper helper) {
        this.helper = helper;
        this.interfaceIntrospectors = new ArrayList<InterfaceIntrospector>();
        this.typeIntrospectors = new ArrayList<TypeIntrospector>();
    }

    @Reference(required=false)
    public void setInterfaceIntrospectors(List<InterfaceIntrospector> interfaceIntrospectors) {
        this.interfaceIntrospectors = interfaceIntrospectors;
    }

    @Reference(required=false)
    public void setTypeIntrospectors(List<TypeIntrospector> typeIntrospectors) {
        this.typeIntrospectors = typeIntrospectors;
    }

    @Override
    public JavaServiceContract introspect(Class<?> interfaze, IntrospectionContext context, ModelObject ... modelObjects) {
        return this.introspect(interfaze, interfaze, context, new ModelObject[0]);
    }

    @Override
    public JavaServiceContract introspect(Class<?> interfaze, Class<?> baseClass, IntrospectionContext context, ModelObject ... modelObjects) {
        JavaServiceContract contract = this.introspectInterface(interfaze, baseClass, context, modelObjects);
        Callback callback = interfaze.getAnnotation(Callback.class);
        if (callback != null) {
            Class<?> callbackClass = callback.value();
            this.introspectCallback(interfaze, callbackClass, contract, context, new ModelObject[0]);
        }
        return contract;
    }

    private void introspectCallback(Class<?> interfaze, Class<?> callbackClass, JavaServiceContract contract, IntrospectionContext context, ModelObject ... modelObjects) {
        if (Void.class.equals(callbackClass)) {
            context.addError(new MissingCallback(interfaze, modelObjects));
            return;
        }
        JavaServiceContract callbackContract = this.introspectInterface(callbackClass, callbackClass, context, new ModelObject[0]);
        if (contract.isRemotable() != callbackContract.isRemotable()) {
            String forwardName = contract.getInterfaceName();
            String callbackName = callbackContract.getInterfaceName();
            InvalidCallbackContract error = new InvalidCallbackContract("The remotable attribute on the forward and callback contract do not match: " + forwardName + "," + callbackName, callbackClass, modelObjects);
            context.addError(error);
        }
        contract.setCallbackContract(callbackContract);
    }

    private JavaServiceContract introspectInterface(Class<?> interfaze, Class<?> baseClass, IntrospectionContext context, ModelObject ... modelObjects) {
        JavaServiceContract contract = new JavaServiceContract(interfaze);
        contract.setInterfaceName(interfaze.getSimpleName());
        boolean remotable = interfaze.isAnnotationPresent(Remotable.class) || interfaze.isAnnotationPresent(Remotable.class);
        contract.setRemotable(remotable);
        List<Operation> operations = this.introspectOperations(interfaze, baseClass, remotable, context, modelObjects);
        contract.setOperations(operations);
        for (InterfaceIntrospector introspector : this.interfaceIntrospectors) {
            introspector.introspect(contract, interfaze, context);
        }
        return contract;
    }

    private List<Operation> introspectOperations(Class<?> interfaze, Class<?> baseClass, boolean remotable, IntrospectionContext context, ModelObject ... modelObjects) {
        Method[] methods = interfaze.getMethods();
        ArrayList<Operation> operations = new ArrayList<Operation>(methods.length);
        for (Method method : methods) {
            String name = method.getName();
            TypeMapping typeMapping = this.getTypeMapping(interfaze, baseClass, context);
            DataType returnType = this.introspectReturnType(method, typeMapping);
            List<DataType> paramTypes = this.introspectParameterTypes(method, typeMapping);
            List<DataType> faultTypes = this.introspectFaultTypes(method, typeMapping);
            Operation operation = new Operation(name, paramTypes, returnType, faultTypes);
            operation.setRemotable(remotable);
            if (method.isAnnotationPresent(OneWay.class)) {
                operation.setOneWay(true);
            }
            for (TypeIntrospector introspector : this.typeIntrospectors) {
                introspector.introspect(operation, method, context);
            }
            if (remotable) {
                this.checkOverloadedOperations(method, operations, context, modelObjects);
            }
            operations.add(operation);
        }
        return operations;
    }

    private DataType introspectReturnType(Method method, TypeMapping typeMapping) {
        Class<?> physicalReturnType = method.getReturnType();
        Type gReturnType = method.getGenericReturnType();
        Type actualReturnType = typeMapping.getActualType(gReturnType);
        return this.createDataType(physicalReturnType, actualReturnType, typeMapping);
    }

    private List<DataType> introspectParameterTypes(Method method, TypeMapping typeMapping) {
        Class<?>[] physicalParameterTypes = method.getParameterTypes();
        Type[] gParamTypes = method.getGenericParameterTypes();
        ArrayList<DataType> parameterDataTypes = new ArrayList<DataType>(gParamTypes.length);
        for (int i = 0; i < gParamTypes.length; ++i) {
            Type gParamType = gParamTypes[i];
            Type actualParamType = typeMapping.getActualType(gParamType);
            DataType dataType = this.createDataType(physicalParameterTypes[i], actualParamType, typeMapping);
            parameterDataTypes.add(dataType);
        }
        return parameterDataTypes;
    }

    private List<DataType> introspectFaultTypes(Method method, TypeMapping typeMapping) {
        Class<?>[] physicalFaultTypes = method.getExceptionTypes();
        Type[] gFaultTypes = method.getGenericExceptionTypes();
        ArrayList<DataType> faultDataTypes = new ArrayList<DataType>(gFaultTypes.length);
        for (int i = 0; i < gFaultTypes.length; ++i) {
            Type gFaultType = gFaultTypes[i];
            Type actualType = typeMapping.getActualType(gFaultType);
            DataType dataType = this.createDataType(physicalFaultTypes[i], actualType, typeMapping);
            faultDataTypes.add(dataType);
        }
        return faultDataTypes;
    }

    private TypeMapping getTypeMapping(Class<?> type, Class<?> baseClass, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(baseClass);
        if (typeMapping == null) {
            typeMapping = new TypeMapping();
            context.addTypeMapping(type, typeMapping);
            this.helper.resolveTypeParameters(type, typeMapping);
        }
        return typeMapping;
    }

    private DataType createDataType(Class<?> rawType, Type actualType, TypeMapping mapping) {
        if (actualType instanceof Class) {
            return new JavaType(rawType);
        }
        JavaTypeInfo info = this.helper.createTypeInfo(actualType, mapping);
        return new JavaGenericType(info);
    }

    private void checkOverloadedOperations(Method method, List<Operation> operations, IntrospectionContext context, ModelObject ... modelObjects) {
        for (Operation entry : operations) {
            String name = method.getName();
            if (!entry.getName().equals(name)) continue;
            OverloadedOperation error = new OverloadedOperation(method, modelObjects);
            context.addError(error);
        }
    }
}

