/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.common.MissingProducerName;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Reference;

public class ComponentConsumerLoader
extends AbstractExtensibleTypeLoader<Consumer<Component>> {
    private static final QName CONSUMER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "consumer");

    public ComponentConsumerLoader(@Reference LoaderRegistry registry) {
        super(registry);
        this.addAttributes("name", "source");
    }

    @Override
    public QName getXMLType() {
        return CONSUMER;
    }

    @Override
    public Consumer<Component> load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingProducerName failure = new MissingProducerName(startLocation);
            context.addError(failure);
            return null;
        }
        String targetAttribute = reader.getAttributeValue(null, "source");
        ArrayList<URI> sources = new ArrayList<URI>();
        Consumer<Component> consumer = new Consumer<Component>(name);
        try {
            if (targetAttribute != null) {
                StringTokenizer tokenizer = new StringTokenizer(targetAttribute);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.startsWith("\\\\")) {
                        token = "domain://" + token.substring(2);
                    }
                    URI target = new URI(token);
                    sources.add(target);
                }
            }
        }
        catch (URISyntaxException e) {
            InvalidValue failure = new InvalidValue("Invalid source format", startLocation, e, consumer);
            context.addError(failure);
        }
        consumer.setSources(sources);
        this.validateAttributes(reader, context, consumer);
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    QName elementName = reader.getName();
                    ModelObject type = this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof Binding) {
                        Binding binding = (Binding)type;
                        boolean check = BindingHelper.checkDuplicateNames(binding, consumer.getBindings(), location, context);
                        if (check) {
                            consumer.addBinding(binding);
                        }
                    } else {
                        if (type == null) break;
                        UnrecognizedElement failure = new UnrecognizedElement(reader, location, consumer);
                        context.addError(failure);
                        break;
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (!CONSUMER.equals(reader.getName())) break;
                    return consumer;
                }
            }
        }
    }
}

