/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Reference;

public class ComponentServiceLoader
extends AbstractExtensibleTypeLoader<Service> {
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service");
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");

    public ComponentServiceLoader(@Reference LoaderRegistry registry) {
        super(registry);
        this.addAttributes("name", "requires", "policySets");
    }

    @Override
    public QName getXMLType() {
        return SERVICE;
    }

    @Override
    public Service load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", startLocation, new ModelObject[0]);
            context.addError(failure);
            return null;
        }
        Service definition = new Service(name);
        this.validateAttributes(reader, context, definition);
        boolean callback = false;
        while (true) {
            int i = reader.next();
            switch (i) {
                case 1: {
                    Location location = reader.getLocation();
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    Object type = this.registry.load(reader, Object.class, context);
                    if (type instanceof ServiceContract) {
                        definition.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof Binding)) {
                            if (type == null) {
                                LoaderUtil.skipToEndElement(reader);
                                if (reader.getEventType() != 2 || !reader.getName().getLocalPart().equals("service")) break;
                                return definition;
                            }
                            context.addError(new UnrecognizedElement(reader, location, definition));
                            break;
                        }
                        Binding binding = (Binding)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, definition.getCallbackBindings(), location, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, definition.getCallbackBindings(), location, context)) {
                                definition.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, definition.getBindings(), location, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, definition.getBindings(), location, context)) {
                                definition.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    if (!SERVICE.equals(reader.getName())) break;
                    return definition;
                }
            }
        }
    }
}

