/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.composite.IllegalBinding;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.ChannelTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ChannelLoader
extends AbstractExtensibleTypeLoader<Channel> {
    private static final QName CHANNEL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "channel");
    private Map<String, ChannelTypeLoader> channelTypeLoaders = Collections.emptyMap();

    public ChannelLoader(@Reference LoaderRegistry registry) {
        super(registry);
        this.addAttributes("name", "requires", "type", "local");
    }

    @Reference(required=false)
    public void setChannelTypeLoaders(Map<String, ChannelTypeLoader> channelTypeLoaders) {
        this.channelTypeLoaders = channelTypeLoaders;
        for (ChannelTypeLoader channelTypeLoader : channelTypeLoaders.values()) {
            this.addAttributes(channelTypeLoader.getAttributes());
        }
    }

    @Override
    public Channel load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Component name not specified", startLocation, new ModelObject[0]);
            context.addError(failure);
            return null;
        }
        String channelType = reader.getAttributeValue(null, "type");
        if (channelType == null) {
            channelType = "default";
        }
        boolean local = Boolean.parseBoolean(reader.getAttributeValue(null, "local"));
        Channel definition = new Channel(name, channelType, local);
        this.validateAttributes(reader, context, definition);
        ChannelTypeLoader channelTypeLoader = this.channelTypeLoaders.get(channelType);
        if (channelTypeLoader == null) {
            context.addError(new InvalidValue("Invalid channel type", startLocation, definition));
        } else {
            channelTypeLoader.load(definition, reader, context);
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    QName elementName = reader.getName();
                    ModelObject type = this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof Binding) {
                        if (local) {
                            context.addError(new IllegalBinding("Bindings cannot be configured on a local channel: " + name, location, (ModelObject)definition));
                            break;
                        }
                        Binding binding = (Binding)type;
                        boolean check = BindingHelper.checkDuplicateNames(binding, definition.getBindings(), location, context);
                        if (check) {
                            definition.addBinding(binding);
                        }
                    } else {
                        if (type == null) break;
                        context.addError(new UnrecognizedElement(reader, location, definition));
                        break;
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                }
                case 2: {
                    QName elementName = reader.getName();
                    if (!CHANNEL.equals(elementName)) break;
                    return definition;
                }
            }
        }
    }

    @Override
    public QName getXMLType() {
        return CHANNEL;
    }
}

