/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.PropertyMany;
import org.fabric3.api.model.type.component.PropertyValue;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.component.Target;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.InvalidAttributes;
import org.fabric3.introspection.xml.common.InvalidPropertyValue;
import org.fabric3.introspection.xml.composite.ComponentConsumerNotFound;
import org.fabric3.introspection.xml.composite.ComponentProducerNotFound;
import org.fabric3.introspection.xml.composite.ComponentPropertyNotFound;
import org.fabric3.introspection.xml.composite.ComponentReferenceNotFound;
import org.fabric3.introspection.xml.composite.ComponentServiceNotFound;
import org.fabric3.introspection.xml.composite.DuplicateComponentReference;
import org.fabric3.introspection.xml.composite.DuplicateComponentService;
import org.fabric3.introspection.xml.composite.DuplicateConfiguredProperty;
import org.fabric3.introspection.xml.composite.InvalidPropertyConfiguration;
import org.fabric3.introspection.xml.composite.InvalidServiceContract;
import org.fabric3.introspection.xml.composite.MissingComponentImplementation;
import org.fabric3.introspection.xml.composite.PropertyValueNotSpecified;
import org.fabric3.introspection.xml.composite.RequiredPropertyNotProvided;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.IncompatibleContracts;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.XmlValidationFailure;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.w3c.dom.Document;

@EagerInit
public class ComponentLoader
extends AbstractExtensibleTypeLoader<Component<?>> {
    private static final QName COMPONENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "component");
    private static final QName PROPERTY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "property");
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service");
    private static final QName REFERENCE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "reference");
    private static final QName PRODUCER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "producer");
    private static final QName CONSUMER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "consumer");
    private LoaderHelper loaderHelper;
    private ContractMatcher contractMatcher;

    public ComponentLoader(LoaderRegistry registry, LoaderHelper loaderHelper) {
        this(registry, loaderHelper, null);
    }

    @Constructor
    public ComponentLoader(@org.oasisopen.sca.annotation.Reference LoaderRegistry registry, @org.oasisopen.sca.annotation.Reference LoaderHelper loaderHelper, @org.oasisopen.sca.annotation.Reference ContractMatcher contractMatcher) {
        super(registry);
        this.addAttributes("name", "autowire", "requires", "policySets", "key", "order");
        this.loaderHelper = loaderHelper;
        this.contractMatcher = contractMatcher;
    }

    @Override
    public Component<?> load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Component name not specified", startLocation, new ModelObject[0]);
            context.addError(failure);
            return null;
        }
        String key = this.loaderHelper.loadKey(reader);
        Component definition = new Component(name);
        int order = this.parserOrder(reader, definition, startLocation, context);
        definition.setContributionUri(context.getContributionUri());
        definition.setKey(key);
        definition.setOrder(order);
        this.validateAttributes(reader, context, definition);
        reader.nextTag();
        QName elementName = reader.getName();
        if (COMPONENT.equals(elementName)) {
            MissingComponentImplementation error = new MissingComponentImplementation("The component " + name + " must specify an implementation", startLocation, definition);
            context.addError(error);
            return definition;
        }
        if (PROPERTY.equals(elementName) || REFERENCE.equals(elementName) || SERVICE.equals(elementName) || PRODUCER.equals(elementName)) {
            MissingComponentImplementation error = new MissingComponentImplementation("The component " + name + " must specify an implementation as the first child element", startLocation, definition);
            context.addError(error);
            return definition;
        }
        Implementation impl = this.registry.load(reader, Implementation.class, context);
        if (impl == null || impl.getComponentType() == null) {
            return definition;
        }
        if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
            throw new AssertionError((Object)"Implementation loader must position the cursor to the end element");
        }
        definition.setImplementation(impl);
        return this.parseSubElements(definition, reader, context);
    }

    @Override
    public QName getXMLType() {
        return COMPONENT;
    }

    private void parseService(Component<?> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        Service service = this.registry.load(reader, Service.class, context);
        if (service == null) {
            return;
        }
        String name = service.getName();
        Service<ComponentType> typeService = componentType.getServices().get(name);
        if (typeService == null) {
            ComponentServiceNotFound failure = new ComponentServiceNotFound(name, definition, startLocation);
            context.addError(failure);
            return;
        }
        this.processServiceContract(service, typeService, startLocation, context);
        if (definition.getServices().containsKey(name)) {
            DuplicateComponentService failure = new DuplicateComponentService(name, startLocation, definition);
            context.addError(failure);
        } else {
            definition.add(service);
        }
    }

    private Component<?> parseSubElements(Component<Implementation<?>> definition, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ComponentType componentType = definition.getComponentType();
        HashMap<Property, Location> propertyLocations = new HashMap<Property, Location>();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    QName qname = reader.getName();
                    if (PROPERTY.equals(qname)) {
                        this.parsePropertyValue(definition, componentType, reader, propertyLocations, context);
                        break;
                    }
                    if (REFERENCE.equals(qname)) {
                        this.parseReference(definition, componentType, reader, context);
                        break;
                    }
                    if (SERVICE.equals(qname)) {
                        this.parseService(definition, componentType, reader, context);
                        break;
                    }
                    if (PRODUCER.equals(qname)) {
                        this.parseProducer(definition, componentType, reader, context);
                        break;
                    }
                    if (CONSUMER.equals(qname)) {
                        this.parseConsumer(definition, componentType, reader, context);
                        break;
                    }
                    UnrecognizedElement failure = new UnrecognizedElement(reader, location, definition);
                    context.addError(failure);
                    LoaderUtil.skipToEndElement(reader);
                    break;
                }
                case 2: {
                    this.validateRequiredProperties(definition, propertyLocations, context);
                    return definition;
                }
            }
        }
    }

    private void parseReference(Component<?> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        XmlValidationFailure failure;
        Location startLocation = reader.getLocation();
        Reference reference = this.registry.load(reader, Reference.class, context);
        if (reference == null) {
            return;
        }
        String name = reference.getName();
        Reference<ComponentType> typeReference = componentType.getReferences().get(name);
        if (typeReference == null) {
            ComponentReferenceNotFound failure2 = new ComponentReferenceNotFound(name, definition, startLocation);
            context.addError(failure2);
            return;
        }
        if (!reference.getCallbackBindings().isEmpty() && typeReference.getServiceContract() != null && typeReference.getServiceContract().getCallbackContract() == null) {
            failure = new InvalidServiceContract("Reference is configured with a callback binding but its service contract is not bidirectional: " + name, startLocation, (ModelObject)reference);
            context.addError(failure);
        }
        this.processReferenceContract(reference, typeReference, startLocation, context);
        if (definition.getReferences().containsKey(name)) {
            failure = new DuplicateComponentReference(name, startLocation, (ModelObject)definition);
            context.addError(failure);
            return;
        }
        this.processMultiplicity(reference, typeReference, startLocation, context);
        definition.add(reference);
    }

    private void parseProducer(Component<Implementation<?>> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        Producer producer = this.registry.load(reader, Producer.class, context);
        if (producer == null) {
            return;
        }
        String name = producer.getName();
        Producer<ComponentType> typeProducer = componentType.getProducers().get(name);
        if (typeProducer == null) {
            ComponentProducerNotFound failure = new ComponentProducerNotFound(name, definition, startLocation);
            context.addError(failure);
            return;
        }
        definition.add(producer);
    }

    private void parseConsumer(Component<Implementation<?>> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        Consumer consumer = this.registry.load(reader, Consumer.class, context);
        if (consumer == null) {
            return;
        }
        String name = consumer.getName();
        Consumer<ComponentType> typeConsumer = componentType.getConsumers().get(name);
        if (typeConsumer == null) {
            ComponentConsumerNotFound failure = new ComponentConsumerNotFound(name, definition, startLocation);
            context.addError(failure);
            return;
        }
        consumer.setType(typeConsumer.getType());
        definition.add(consumer);
    }

    private void parsePropertyValue(Component<?> definition, ComponentType componentType, XMLStreamReader reader, Map<Property, Location> propertyLocations, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        PropertyValue value = this.registry.load(reader, PropertyValue.class, context);
        if (value == null) {
            return;
        }
        String name = value.getName();
        Property property = componentType.getProperties().get(name);
        if (property == null) {
            ComponentPropertyNotFound failure = new ComponentPropertyNotFound(value.getName(), definition, startLocation);
            context.addError(failure);
            return;
        }
        this.validatePropertyType(value, property, startLocation, context);
        propertyLocations.put(property, startLocation);
        if (definition.getPropertyValues().containsKey(value.getName())) {
            String id = value.getName();
            DuplicateConfiguredProperty failure = new DuplicateConfiguredProperty(id, definition, startLocation);
            context.addError(failure);
        } else {
            definition.add(value);
        }
        if (value.getValue() != null && value.getValue().getDocumentElement().getChildNodes().getLength() == 0 && property.isRequired()) {
            PropertyValueNotSpecified failure = new PropertyValueNotSpecified(value.getName(), definition, startLocation);
            context.addError(failure);
        }
    }

    private void processServiceContract(Service service, Service<ComponentType> typeService, Location location, IntrospectionContext context) {
        if (service.getServiceContract() == null) {
            service.setServiceContract(typeService.getServiceContract());
        } else if (this.contractMatcher != null) {
            MatchResult result = this.contractMatcher.isAssignableFrom(service.getServiceContract(), typeService.getServiceContract(), true);
            if (!result.isAssignable()) {
                String name = service.getName();
                IncompatibleContracts error = new IncompatibleContracts("The component service interface " + name + " is not compatible with the promoted service " + typeService.getName() + ": " + result.getError(), location, (ModelObject)service);
                context.addError(error);
            } else {
                this.matchServiceCallbackContracts(service, typeService, location, context);
            }
        }
    }

    private void processReferenceContract(Reference reference, Reference<ComponentType> typeReference, Location location, IntrospectionContext context) {
        if (reference.getServiceContract() == null) {
            reference.setServiceContract(typeReference.getServiceContract());
        } else if (this.contractMatcher != null) {
            MatchResult result = this.contractMatcher.isAssignableFrom(typeReference.getServiceContract(), reference.getServiceContract(), true);
            if (!result.isAssignable()) {
                String name = reference.getName();
                IncompatibleContracts error = new IncompatibleContracts("The component reference contract " + name + " is not compatible with the promoted reference " + typeReference.getName() + ": " + result.getError(), location, (ModelObject)reference);
                context.addError(error);
            } else {
                this.matchReferenceCallbackContracts(reference, typeReference, location, context);
            }
        }
    }

    private void matchServiceCallbackContracts(Service service, Service<ComponentType> typeService, Location location, IntrospectionContext context) {
        ServiceContract callbackContract = service.getServiceContract().getCallbackContract();
        if (callbackContract == null) {
            return;
        }
        ServiceContract typeCallbackContract = typeService.getServiceContract().getCallbackContract();
        if (typeCallbackContract == null) {
            IncompatibleContracts error = new IncompatibleContracts("Component type for service " + service.getName() + " does not have a callback contract", location, (ModelObject)service);
            context.addError(error);
            return;
        }
        MatchResult result = this.contractMatcher.isAssignableFrom(typeCallbackContract, callbackContract, true);
        if (!result.isAssignable()) {
            String name = service.getName();
            IncompatibleContracts error = new IncompatibleContracts("The component service " + name + " callback contract is not compatible with the promoted service " + typeService.getName() + " callback contract: " + result.getError(), location, (ModelObject)service);
            context.addError(error);
        }
    }

    private void matchReferenceCallbackContracts(Reference reference, Reference<ComponentType> typeReference, Location location, IntrospectionContext context) {
        ServiceContract callbackContract = reference.getServiceContract().getCallbackContract();
        if (callbackContract == null) {
            return;
        }
        ServiceContract typeCallbackContract = typeReference.getServiceContract().getCallbackContract();
        if (typeCallbackContract == null) {
            IncompatibleContracts error = new IncompatibleContracts("Component type for reference " + reference.getName() + " does not have a callback contract", location, (ModelObject)reference);
            context.addError(error);
            return;
        }
        MatchResult result = this.contractMatcher.isAssignableFrom(typeCallbackContract, callbackContract, true);
        if (!result.isAssignable()) {
            String name = reference.getName();
            IncompatibleContracts error = new IncompatibleContracts("The component reference " + name + " callback contract is not compatible with the promoted reference " + typeReference.getName() + " callback contract: " + result.getError(), location, (ModelObject)reference);
            context.addError(error);
        }
    }

    private void processMultiplicity(Reference<Component> reference, Reference<ComponentType> typeReference, Location location, IntrospectionContext context) {
        String name = reference.getName();
        if (reference.getMultiplicity() == null) {
            Multiplicity multiplicity = typeReference.getMultiplicity();
            reference.setMultiplicity(multiplicity);
        } else if (!this.loaderHelper.canNarrow(reference.getMultiplicity(), typeReference.getMultiplicity())) {
            InvalidValue failure = new InvalidValue("The multiplicity setting for reference " + name + " widens the default setting", location, new ModelObject[0]);
            context.addError(failure);
        }
        List<Target> targets = reference.getTargets();
        Multiplicity multiplicity = reference.getMultiplicity();
        if (targets.size() > 1 && (Multiplicity.ZERO_ONE == multiplicity || Multiplicity.ONE_ONE == multiplicity)) {
            InvalidValue failure = new InvalidValue("Multiple targets configured on reference " + name + ", which takes a single target", location, new ModelObject[0]);
            context.addError(failure);
        }
    }

    private int parserOrder(XMLStreamReader reader, Component<Implementation<?>> definition, Location startLocation, IntrospectionContext context) {
        String orderStr = reader.getAttributeValue(null, "order");
        int order = Integer.MIN_VALUE;
        if (orderStr != null) {
            try {
                order = Integer.parseInt(orderStr);
            }
            catch (NumberFormatException e) {
                InvalidValue failure = new InvalidValue("Invalid order value", startLocation, definition);
                context.addError(failure);
            }
        }
        return order;
    }

    private void validateRequiredProperties(Component<?> definition, Map<Property, Location> propertyLocations, IntrospectionContext context) {
        ComponentType type = definition.getComponentType();
        Map<String, Property> properties = type.getProperties();
        Map<String, PropertyValue> values = definition.getPropertyValues();
        for (Property property : properties.values()) {
            PropertyValue value = values.get(property.getName());
            if (property.isRequired() && value == null) {
                Property typeProperty = type.getProperties().get(property.getName());
                if (typeProperty != null && typeProperty.getSource() != null) continue;
                Location location = propertyLocations.get(property);
                RequiredPropertyNotProvided failure = new RequiredPropertyNotProvided(property, definition, location);
                context.addError(failure);
                continue;
            }
            if (value == null) continue;
            Location location = propertyLocations.get(property);
            this.validateAndSetMany(value, property, location, context);
        }
    }

    private void validateAndSetMany(PropertyValue propertyValue, Property property, Location location, IntrospectionContext context) {
        PropertyMany propertyMany = propertyValue.getMany();
        if (PropertyMany.NOT_SPECIFIED == propertyMany) {
            if (property.isMany()) {
                propertyValue.setMany(PropertyMany.MANY);
            } else {
                propertyValue.setMany(PropertyMany.SINGLE);
            }
        } else if (PropertyMany.MANY == propertyMany) {
            if (!property.isMany()) {
                InvalidPropertyConfiguration error = new InvalidPropertyConfiguration("Illegal attempt to make a property many-valued when its component type is single-valued", location, (ModelObject)property);
                context.addError(error);
                return;
            }
            propertyValue.setMany(PropertyMany.MANY);
        } else {
            propertyValue.setMany(PropertyMany.SINGLE);
        }
        Document value = propertyValue.getValue();
        if (value != null && PropertyMany.MANY != propertyValue.getMany() && value.getDocumentElement().getChildNodes().getLength() > 1) {
            String name = propertyValue.getName();
            InvalidPropertyValue error = new InvalidPropertyValue("A single-valued property is configured with multiple values: " + name, location, (ModelObject)property);
            context.addError(error);
        }
    }

    private void validatePropertyType(PropertyValue value, Property property, Location location, IntrospectionContext context) {
        QName propType = property.getType();
        QName propElement = property.getElement();
        QName valType = value.getType();
        QName valElement = value.getElement();
        if (propType != null) {
            if (valElement != null) {
                InvalidAttributes error = new InvalidAttributes("Cannot specify property schema type and element type on property configuration: " + value.getName(), location, (ModelObject)property);
                context.addError(error);
            } else if (valType != null && !valType.equals(propType)) {
                InvalidAttributes error = new InvalidAttributes("Property type " + propType + " and property configuration type " + valType + " do not match: " + value.getName(), location, (ModelObject)property);
                context.addError(error);
            }
        } else if (propElement != null) {
            if (valType != null) {
                InvalidAttributes error = new InvalidAttributes("Cannot specify property element type and property configuration schema type: " + value.getName(), location, (ModelObject)property);
                context.addError(error);
            } else if (valElement != null && !valElement.equals(propElement)) {
                InvalidAttributes error = new InvalidAttributes("Property element type " + propElement + " and property configuration element type " + valElement + " do not match: " + value.getName(), location, (ModelObject)property);
                context.addError(error);
            }
        }
    }
}

