/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.contribution.ArtifactValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Include;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.PropertyValue;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.api.model.type.component.Wire;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.composite.DuplicateChannelName;
import org.fabric3.introspection.xml.composite.DuplicateComponentName;
import org.fabric3.introspection.xml.composite.DuplicateInclude;
import org.fabric3.introspection.xml.composite.StatefulNamespaceContext;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.CompositeConstants;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class CompositeLoader
extends AbstractExtensibleTypeLoader<Composite> {
    @Constructor
    public CompositeLoader(@Reference LoaderRegistry registry) {
        super(registry);
        this.addAttributes("name", "autowire", "targetNamespace", "local", "requires", "policySets", "constrainingType", "channel", "schemaLocation", "deployable", "modes", "environments");
    }

    @Override
    public QName getXMLType() {
        return CompositeConstants.COMPOSITE;
    }

    @Override
    public Composite load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        HashMap<ModelObject, Location> locations = new HashMap<ModelObject, Location>();
        String name = reader.getAttributeValue(null, "name");
        String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
        DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(context, targetNamespace);
        QName compositeName = new QName(targetNamespace, name);
        NamespaceContext nsContext = this.createNamespaceContext(reader);
        Composite type = new Composite(compositeName);
        String deployable = reader.getAttributeValue(null, "deployable");
        type.setDeployable(Boolean.parseBoolean(deployable));
        String modes = reader.getAttributeValue(null, "modes");
        String environments = reader.getAttributeValue(null, "environments");
        if (environments != null) {
            type.setEnvironments(Arrays.asList(environments.split(" ")));
        }
        this.parseModes(modes, type, reader, context);
        type.setContributionUri(context.getContributionUri());
        this.validateAttributes(reader, context, type);
        block4: while (true) {
            int val = reader.next();
            switch (val) {
                case 1: {
                    QName qname = reader.getName();
                    if (CompositeConstants.INCLUDE.equals(qname)) {
                        this.handleInclude(type, reader, locations, compositeName, childContext, context);
                        continue block4;
                    }
                    if (CompositeConstants.CHANNEL.equals(qname)) {
                        this.handleChannel(type, reader, locations, compositeName, childContext, context);
                        continue block4;
                    }
                    if (CompositeConstants.COMPONENT.equals(qname)) {
                        boolean valid = this.handleComponent(type, reader, nsContext, locations, compositeName, childContext, context);
                        if (valid) continue block4;
                        this.updateContext(context, childContext, compositeName);
                        continue block4;
                    }
                    if (CompositeConstants.WIRE.equals(qname)) {
                        this.handleWire(type, reader, compositeName, childContext, context);
                        continue block4;
                    }
                    this.handleExtensionElement(type, reader, childContext);
                    continue block4;
                }
                case 2: {
                    if (!CompositeConstants.COMPOSITE.equals(reader.getName())) continue block4;
                    this.updateContext(context, childContext, compositeName);
                    return type;
                }
            }
        }
    }

    private void handleExtensionElement(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        ModelObject modelObject = this.registry.load(reader, ModelObject.class, context);
        if (modelObject instanceof Property) {
            type.add((Property)modelObject);
        } else if (modelObject instanceof Component) {
            type.add((Component)modelObject);
        } else if (modelObject instanceof Resource) {
            type.add((Resource)modelObject);
        } else if (modelObject != null) {
            UnrecognizedElement failure = new UnrecognizedElement(reader, startLocation, type);
            context.addError(failure);
        }
    }

    private void handleWire(Composite type, XMLStreamReader reader, QName compositeName, IntrospectionContext context, IntrospectionContext parentContext) throws XMLStreamException {
        Wire wire = this.registry.load(reader, Wire.class, context);
        if (wire == null) {
            this.updateContext(parentContext, context, compositeName);
            return;
        }
        type.add(wire);
    }

    private boolean handleComponent(Composite type, XMLStreamReader reader, NamespaceContext nsContext, Map<ModelObject, Location> locations, QName compositeName, IntrospectionContext context, IntrospectionContext parentContext) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        Component component = this.registry.load(reader, Component.class, context);
        if (component == null) {
            this.updateContext(parentContext, context, compositeName);
            return false;
        }
        String key = component.getName();
        if (type.getComponents().containsKey(key)) {
            DuplicateComponentName failure = new DuplicateComponentName(key, startLocation, (ModelObject)type);
            context.addError(failure);
            return false;
        }
        type.add(component);
        if (component.getComponentType() == null) {
            return false;
        }
        for (PropertyValue value : component.getPropertyValues().values()) {
            value.setNamespaceContext(nsContext);
        }
        locations.put(component, startLocation);
        return true;
    }

    private void handleChannel(Composite type, XMLStreamReader reader, Map<ModelObject, Location> locations, QName compositeName, IntrospectionContext context, IntrospectionContext parentContext) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        Channel channel = this.registry.load(reader, Channel.class, context);
        if (channel == null) {
            this.updateContext(parentContext, context, compositeName);
            return;
        }
        String key = channel.getName();
        if (type.getChannels().containsKey(key)) {
            DuplicateChannelName failure = new DuplicateChannelName(key, startLocation, (ModelObject)type);
            context.addError(failure);
            return;
        }
        locations.put(channel, startLocation);
        type.add(channel);
    }

    private void handleInclude(Composite type, XMLStreamReader reader, Map<ModelObject, Location> locations, QName compositeName, IntrospectionContext context, IntrospectionContext parentContext) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        Include include = this.registry.load(reader, Include.class, context);
        if (include == null) {
            this.updateContext(parentContext, context, compositeName);
            return;
        }
        QName includeName = include.getName();
        if (type.getIncludes().containsKey(includeName)) {
            String identifier = includeName.toString();
            DuplicateInclude failure = new DuplicateInclude(identifier, startLocation, include);
            context.addError(failure);
            return;
        }
        Composite included = include.getIncluded();
        if (included == null) {
            return;
        }
        for (Component<Implementation<?>> definition : included.getComponents().values()) {
            String key = definition.getName();
            if (!type.getComponents().containsKey(key)) continue;
            DuplicateComponentName failure = new DuplicateComponentName(key, startLocation, (ModelObject)type);
            context.addError(failure);
        }
        locations.put(include, startLocation);
        type.add(include);
    }

    private void updateContext(IntrospectionContext context, IntrospectionContext childContext, QName compositeName) {
        if (childContext.hasErrors() || childContext.hasWarnings()) {
            ArtifactValidationFailure artifactFailure;
            URI uri = context.getContributionUri();
            if (childContext.hasErrors()) {
                artifactFailure = new ArtifactValidationFailure(uri, compositeName.toString());
                artifactFailure.addFailures(childContext.getErrors());
                context.addError(artifactFailure);
            }
            if (childContext.hasWarnings()) {
                artifactFailure = new ArtifactValidationFailure(uri, compositeName.toString());
                artifactFailure.addFailures(childContext.getWarnings());
                context.addWarning(artifactFailure);
            }
        }
    }

    private NamespaceContext createNamespaceContext(XMLStreamReader reader) {
        StatefulNamespaceContext namespaceContext = new StatefulNamespaceContext();
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null) continue;
            String namespaceUri = reader.getNamespaceURI(prefix);
            namespaceContext.addNamespace(prefix, namespaceUri);
        }
        return namespaceContext;
    }

    private void parseModes(String modes, Composite type, XMLStreamReader reader, IntrospectionContext context) {
        if (modes != null) {
            String[] tokens = modes.split(" ");
            ArrayList<RuntimeMode> runtimeModes = new ArrayList<RuntimeMode>();
            for (String token : tokens) {
                try {
                    runtimeModes.add(RuntimeMode.valueOf(token.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    context.addError(new InvalidValue("Invalid runtime mode: " + token, reader.getLocation(), type));
                }
            }
            type.setModes(runtimeModes);
        }
    }
}

