/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.composite.MissingComposite;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.ElementLoadFailure;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.model.type.component.CompositeImplementation;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ImplementationCompositeLoader
extends AbstractExtensibleTypeLoader<CompositeImplementation> {
    private static final QName IMPL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementation.composite");
    private MetaDataStore store;

    public ImplementationCompositeLoader(@Reference LoaderRegistry registry, @Reference MetaDataStore store) {
        super(registry);
        this.addAttributes("name", "scdlResource", "requires", "policySets");
        this.store = store;
    }

    @Override
    public QName getXMLType() {
        return IMPL;
    }

    @Override
    public CompositeImplementation load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String scdlResource = reader.getAttributeValue(null, "scdlResource");
        CompositeImplementation implementation = scdlResource != null ? this.parseScdlResource(scdlResource, startLocation, context) : this.resolveByName(reader, startLocation, context);
        this.validateAttributes(reader, context, implementation);
        LoaderUtil.skipToEndElement(reader);
        return implementation;
    }

    private CompositeImplementation parseScdlResource(String scdlResource, Location startLocation, IntrospectionContext context) {
        Composite composite;
        ClassLoader cl = context.getClassLoader();
        CompositeImplementation impl = new CompositeImplementation();
        URI contributionUri = context.getContributionUri();
        URL url = cl.getResource(scdlResource);
        if (url == null) {
            MissingComposite failure = new MissingComposite("Composite file not found: " + scdlResource, startLocation, (ModelObject)impl);
            context.addError(failure);
            return impl;
        }
        UrlSource source = new UrlSource(url);
        DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(contributionUri, cl, url);
        try {
            composite = this.registry.load(source, Composite.class, (IntrospectionContext)childContext);
            if (childContext.hasErrors()) {
                context.addErrors(childContext.getErrors());
            }
            if (childContext.hasWarnings()) {
                context.addWarnings(childContext.getWarnings());
            }
            if (composite == null) {
                return null;
            }
        }
        catch (LoaderException e) {
            ElementLoadFailure failure = new ElementLoadFailure("Error loading element", e, startLocation);
            context.addError(failure);
            return null;
        }
        impl.setName(composite.getName());
        impl.setComponentType(composite);
        return impl;
    }

    private CompositeImplementation resolveByName(XMLStreamReader reader, Location startLocation, IntrospectionContext context) {
        String nameAttr = reader.getAttributeValue(null, "name");
        if (nameAttr == null || nameAttr.length() == 0) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", startLocation, new ModelObject[0]);
            context.addError(failure);
            return null;
        }
        CompositeImplementation impl = new CompositeImplementation();
        URI contributionUri = context.getContributionUri();
        QName name = LoaderUtil.getQName(nameAttr, context.getTargetNamespace(), reader.getNamespaceContext());
        try {
            QNameSymbol symbol = new QNameSymbol(name);
            ResourceElement<QNameSymbol, Composite> element = this.store.resolve(contributionUri, Composite.class, symbol, context);
            if (element == null) {
                String id = name.toString();
                MissingComposite failure = new MissingComposite("Composite not found: " + id, startLocation, (ModelObject)impl);
                context.addError(failure);
                URI uri = context.getContributionUri();
                Composite pointer = new Composite(name, uri);
                impl.setComponentType(pointer);
                return impl;
            }
            impl.setComponentType((ComponentType)element.getValue());
            return impl;
        }
        catch (Fabric3Exception e) {
            ElementLoadFailure failure = new ElementLoadFailure("Error loading element", e, startLocation);
            context.addError(failure);
            return null;
        }
    }
}

