/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.template;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.introspection.xml.template.TemplateParserMonitor;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.ExtensionsInitialized;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.xml.LocationAwareXMLStreamReader;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management
public class SystemConfigTemplateParser
implements Fabric3EventListener<ExtensionsInitialized> {
    private LoaderRegistry loaderRegistry;
    private EventService eventService;
    private TemplateParserMonitor monitor;
    private XMLStreamReader reader;

    public SystemConfigTemplateParser(@Reference LoaderRegistry loaderRegistry, @Reference EventService eventService, @Monitor TemplateParserMonitor monitor) {
        this.loaderRegistry = loaderRegistry;
        this.eventService = eventService;
        this.monitor = monitor;
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:templates")
    public void setTemplateConfig(XMLStreamReader reader) {
        this.reader = new LocationAwareXMLStreamReader(reader, "system configuration");
    }

    @Init
    public void init() {
        this.eventService.subscribe(ExtensionsInitialized.class, this);
    }

    @Destroy
    public void destroy() {
        this.eventService.unsubscribe(ExtensionsInitialized.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ExtensionsInitialized event) {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.nextTag();
            this.reader.nextTag();
            ClassLoader classLoader = this.getClass().getClassLoader();
            DefaultIntrospectionContext context = new DefaultIntrospectionContext(Names.HOST_CONTRIBUTION, classLoader, null);
            this.loaderRegistry.load(this.reader, ModelObject.class, (IntrospectionContext)context);
            if (context.hasErrors()) {
                List<ValidationFailure> errors = context.getErrors();
                for (ValidationFailure error : errors) {
                    this.monitor.parseError(error.getMessage());
                }
            }
        }
        catch (XMLStreamException e) {
            this.monitor.error(e);
        }
        finally {
            this.close();
        }
    }

    private void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            this.reader = null;
        }
    }
}

