/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.template;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.introspection.xml.template.TemplateNotFound;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TemplateRegistry;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class TemplateLoader
extends AbstractValidatingTypeLoader<ModelObject> {
    private TemplateRegistry registry;
    private Class<? extends ModelObject> expectedType;

    public TemplateLoader(@Reference TemplateRegistry registry, @Property(name="expectedType") String expectedType) {
        this.registry = registry;
        try {
            this.expectedType = this.getClass().getClassLoader().loadClass(expectedType);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        this.addAttributes("name");
    }

    @Override
    public ModelObject load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        this.validateAttributes(reader, context, new ModelObject[0]);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute error = new MissingAttribute("Attribute name must be specified", startLocation, new ModelObject[0]);
            context.addError(error);
            LoaderUtil.skipToEndElement(reader);
            return null;
        }
        ModelObject parsed = this.registry.resolve(this.expectedType, name);
        if (parsed == null) {
            TemplateNotFound error = new TemplateNotFound(name, startLocation);
            context.addError(error);
        }
        LoaderUtil.skipToEndElement(reader);
        return parsed;
    }
}

