/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.appender.component;

import java.net.URI;
import java.nio.ByteBuffer;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.monitor.appender.component.PhysicalComponentAppender;
import org.fabric3.monitor.spi.appender.Appender;
import org.fabric3.monitor.spi.appender.AppenderBuilder;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ComponentAppenderBuilder
implements AppenderBuilder<PhysicalComponentAppender> {
    private ComponentManager componentManager;

    public ComponentAppenderBuilder(@Reference ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Override
    public Appender build(PhysicalComponentAppender definition) throws Fabric3Exception {
        URI uri = URI.create("fabric3://runtime/" + definition.getComponentName());
        Component component = this.componentManager.getComponent(uri);
        if (component == null) {
            throw new Fabric3Exception("Component not found: " + uri);
        }
        if (!(component instanceof AtomicComponent)) {
            throw new Fabric3Exception("Component must be atomic: " + uri);
        }
        AtomicComponent atomicComponent = (AtomicComponent)component;
        return new AppenderAdapter(atomicComponent);
    }

    private class AppenderAdapter
    implements Appender {
        private AtomicComponent atomicComponent;
        private Appender delegate;

        private AppenderAdapter(AtomicComponent atomicComponent) {
            this.atomicComponent = atomicComponent;
        }

        @Override
        public void start() {
            Object instance = this.atomicComponent.getInstance();
            if (!(instance instanceof Appender)) {
                throw new Fabric3Exception("Component does not implement " + Appender.class.getName() + ": " + this.atomicComponent.getUri());
            }
            this.delegate = (Appender)instance;
        }

        @Override
        public void stop() {
        }

        @Override
        public void write(ByteBuffer buffer) {
            this.delegate.write(buffer);
        }
    }
}

