/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.appender.component;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.monitor.appender.component.ComponentAppenderDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ComponentAppenderLoader
extends AbstractValidatingTypeLoader<ComponentAppenderDefinition> {
    private static final QName SCA_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "appender.component");
    private static final QName F3_TYPE = new QName("urn:fabric3.org", "appender.component");
    private LoaderRegistry registry;

    public ComponentAppenderLoader(@Reference LoaderRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void init() {
        this.registry.registerLoader(F3_TYPE, this);
        this.registry.registerLoader(SCA_TYPE, this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregisterLoader(F3_TYPE);
        this.registry.unregisterLoader(SCA_TYPE);
    }

    @Override
    public ComponentAppenderDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.addAttributes("name");
        this.validateAttributes(reader, context, new ModelObject[0]);
        String componentName = reader.getAttributeValue(null, "name");
        if (componentName == null) {
            ComponentAppenderDefinition definition = new ComponentAppenderDefinition("");
            MissingAttribute error = new MissingAttribute("A component name must be defined for the appender", reader.getLocation(), definition);
            context.addError(error);
            return definition;
        }
        return new ComponentAppenderDefinition(componentName);
    }
}

