/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.appender.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.monitor.appender.console.ConsoleAppender;
import org.fabric3.monitor.appender.console.ConsoleAppenderDefinition;
import org.fabric3.monitor.appender.factory.AppenderFactoryMonitor;
import org.fabric3.monitor.spi.appender.Appender;
import org.fabric3.monitor.spi.appender.AppenderBuilder;
import org.fabric3.monitor.spi.appender.AppenderFactory;
import org.fabric3.monitor.spi.appender.AppenderGenerator;
import org.fabric3.monitor.spi.model.physical.PhysicalAppender;
import org.fabric3.monitor.spi.model.type.AppenderDefinition;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.oasisopen.sca.annotation.Reference;

public class AppenderFactoryImpl
implements AppenderFactory {
    private LoaderRegistry registry;
    private AppenderFactoryMonitor monitor;
    private Map<Class<?>, AppenderGenerator<?>> appenderGenerators;
    private Map<Class<?>, AppenderBuilder<?>> appenderBuilders;

    public AppenderFactoryImpl(@Reference LoaderRegistry registry, @Monitor AppenderFactoryMonitor monitor) {
        this.registry = registry;
        this.monitor = monitor;
    }

    @Reference
    public void setAppenderGenerators(Map<Class<?>, AppenderGenerator<?>> appenderGenerators) {
        this.appenderGenerators = appenderGenerators;
    }

    @Reference
    public void setAppenderBuilders(Map<Class<?>, AppenderBuilder<?>> appenderBuilders) {
        this.appenderBuilders = appenderBuilders;
    }

    @Override
    public List<Appender> instantiateDefaultAppenders() {
        return Collections.singletonList(new ConsoleAppender());
    }

    @Override
    public List<Appender> instantiate(XMLStreamReader reader) {
        List<AppenderDefinition> definitions = this.load(reader);
        List<PhysicalAppender> physicalAppenders = this.generate(definitions);
        return this.build(definitions, physicalAppenders);
    }

    private List<AppenderDefinition> load(XMLStreamReader reader) throws Fabric3Exception {
        ArrayList<AppenderDefinition> appenderDefinitions = new ArrayList<AppenderDefinition>();
        HashSet<String> definedTypes = new HashSet<String>();
        try {
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        AppenderDefinition appenderDefinition;
                        if (!reader.getName().getLocalPart().startsWith("appender.")) break;
                        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
                        ModelObject modelObject = this.registry.load(reader, ModelObject.class, (IntrospectionContext)context);
                        if (context.hasErrors()) {
                            this.monitor.configurationError();
                            for (ValidationFailure error : context.getErrors()) {
                                this.monitor.configurationErrorDetail("Error reported: " + error.getMessage());
                            }
                            if (!definedTypes.contains("console")) {
                                appenderDefinition = new ConsoleAppenderDefinition();
                                appenderDefinitions.add(appenderDefinition);
                            }
                            return appenderDefinitions;
                        }
                        if (modelObject instanceof AppenderDefinition) {
                            appenderDefinition = (AppenderDefinition)modelObject;
                            if (definedTypes.contains(appenderDefinition.getType())) {
                                this.monitor.multipleAppenders(appenderDefinition.getType());
                                break;
                            }
                            definedTypes.add(appenderDefinition.getType());
                            appenderDefinitions.add(appenderDefinition);
                            break;
                        }
                        throw new Fabric3Exception("Unexpected type: " + modelObject);
                    }
                    case 2: {
                        if (!"appenders".equals(reader.getName().getLocalPart())) break;
                        return appenderDefinitions;
                    }
                    case 8: {
                        throw new AssertionError((Object)"End of document encountered");
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new Fabric3Exception(e);
        }
    }

    private List<PhysicalAppender> generate(List<AppenderDefinition> definitions) {
        ArrayList<PhysicalAppender> physicalDefinitions = new ArrayList<PhysicalAppender>(definitions.size());
        for (AppenderDefinition definition : definitions) {
            AppenderGenerator<?> generator = this.appenderGenerators.get(definition.getClass());
            if (generator == null) {
                throw new Fabric3Exception("Unknown appender type: " + definition.getClass());
            }
            PhysicalAppender physicalDefinition = generator.generateResource(definition);
            physicalDefinitions.add(physicalDefinition);
        }
        return physicalDefinitions;
    }

    private List<Appender> build(List<AppenderDefinition> definitions, List<PhysicalAppender> physicalDefinitions) {
        ArrayList<Appender> appenders = new ArrayList<Appender>(definitions.size());
        for (PhysicalAppender physicalAppender : physicalDefinitions) {
            AppenderBuilder<?> builder = this.appenderBuilders.get(physicalAppender.getClass());
            if (builder == null) {
                throw new Fabric3Exception("Unknown appender type: " + physicalAppender.getClass());
            }
            Appender appender = builder.build(physicalAppender);
            appenders.add(appender);
        }
        return appenders;
    }
}

