/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.appender.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.monitor.appender.file.RollStrategy;
import org.fabric3.monitor.spi.appender.Appender;

public class FileAppender
implements Appender {
    private File file;
    private RollStrategy strategy;
    private FileOutputStream stream;
    private FileChannel fileChannel;
    private boolean reliable;

    public FileAppender(File file, RollStrategy strategy, boolean reliable) {
        this.file = file;
        this.strategy = strategy;
        this.reliable = reliable;
    }

    @Override
    public void start() {
        this.initializeChannel();
    }

    @Override
    public void stop() {
        try {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
    }

    @Override
    public synchronized void write(ByteBuffer buffer) {
        try {
            this.roll();
            this.fileChannel.write(buffer);
            if (this.reliable) {
                this.fileChannel.force(false);
            }
        }
        catch (ClosedChannelException cce) {
            try {
                this.initializeChannel();
                this.fileChannel.write(buffer);
                if (this.reliable) {
                    this.fileChannel.force(false);
                }
            }
            catch (IOException ioe) {
                throw new Fabric3Exception(ioe);
            }
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
    }

    private void initializeChannel() {
        try {
            this.stream = new FileOutputStream(this.file, true);
            this.fileChannel = this.stream.getChannel();
        }
        catch (FileNotFoundException e) {
            throw new Fabric3Exception(e);
        }
    }

    private void roll() throws IOException {
        if (this.strategy.checkRoll(this.file)) {
            this.stream.close();
            File backup = this.strategy.getBackup(this.file);
            FileHelper.copyFile(this.file, backup);
            this.file.delete();
            this.initializeChannel();
        }
    }
}

