/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.appender.file;

import java.io.File;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.monitor.appender.file.FileAppender;
import org.fabric3.monitor.appender.file.NoRollStrategy;
import org.fabric3.monitor.appender.file.PhysicalFileAppender;
import org.fabric3.monitor.appender.file.SizeRollStrategy;
import org.fabric3.monitor.spi.appender.Appender;
import org.fabric3.monitor.spi.appender.AppenderBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FileAppenderBuilder
implements AppenderBuilder<PhysicalFileAppender> {
    private HostInfo hostInfo;

    public FileAppenderBuilder(@Reference HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    @Override
    public Appender build(PhysicalFileAppender fileAppender) throws Fabric3Exception {
        File outputDir = new File(this.hostInfo.getDataDir(), "logs");
        outputDir.mkdirs();
        File outputFile = new File(outputDir, fileAppender.getFileName());
        String rollType = fileAppender.getRollType();
        if ("none".equals(rollType)) {
            NoRollStrategy strategy = new NoRollStrategy();
            return new FileAppender(outputFile, strategy, false);
        }
        if ("size".equals(rollType)) {
            long rollSize = fileAppender.getRollSize();
            int maxBackups = fileAppender.getMaxBackups();
            SizeRollStrategy strategy = new SizeRollStrategy(rollSize, maxBackups);
            return new FileAppender(outputFile, strategy, false);
        }
        throw new Fabric3Exception("Unknown roll type: " + rollType);
    }
}

