/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.appender.file;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.monitor.appender.file.FileAppenderDefinition;
import org.fabric3.monitor.appender.file.LoaderMonitor;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FileAppenderLoader
extends AbstractValidatingTypeLoader<FileAppenderDefinition> {
    private static final QName SCA_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "appender.file");
    private static final QName F3_TYPE = new QName("urn:fabric3.org", "appender.file");
    private static final String FABRIC3_LOG = "fabric3.log";
    private static final long SIZE_100MB = 0x6400000L;
    private LoaderRegistry registry;
    private LoaderMonitor monitor;

    public FileAppenderLoader(@Reference LoaderRegistry registry, @Monitor LoaderMonitor monitor) {
        this.registry = registry;
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.registry.registerLoader(F3_TYPE, this);
        this.registry.registerLoader(SCA_TYPE, this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregisterLoader(F3_TYPE);
        this.registry.unregisterLoader(SCA_TYPE);
    }

    @Override
    public FileAppenderDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.addAttributes("file", "roll.type", "roll.size", "max.backups");
        this.validateAttributes(reader, context, new ModelObject[0]);
        String fileName = reader.getAttributeValue(null, "file");
        Location location = reader.getLocation();
        if (fileName == null) {
            FileAppenderDefinition definition = new FileAppenderDefinition("");
            if (location == null) {
                fileName = FABRIC3_LOG;
            } else {
                MissingAttribute error = new MissingAttribute("A file must be defined for the appender", location, definition);
                context.addError(error);
                return definition;
            }
        }
        String rollType = reader.getAttributeValue(null, "roll.type");
        long rollSize = 0x6400000L;
        if (rollType == null || "none".equals(rollType)) {
            return new FileAppenderDefinition(fileName);
        }
        if ("size".equals(rollType)) {
            String sizeStr = reader.getAttributeValue(null, "roll.size");
            if (sizeStr != null) {
                try {
                    rollSize = Long.parseLong(sizeStr);
                }
                catch (NumberFormatException e) {
                    this.monitor.invalidRollSize(fileName, sizeStr);
                }
            }
            String maxBackupsStr = reader.getAttributeValue(null, "max.backups");
            int maxBackups = -1;
            if (maxBackupsStr != null) {
                try {
                    maxBackups = Integer.parseInt(maxBackupsStr);
                }
                catch (NumberFormatException e) {
                    this.monitor.invalidMaxBackups(fileName, maxBackupsStr);
                }
                if (maxBackups < 1) {
                    this.monitor.invalidMaxBackups(fileName, maxBackupsStr);
                    maxBackups = -1;
                }
            }
            return new FileAppenderDefinition(fileName, rollType, rollSize, maxBackups);
        }
        this.monitor.invalidRollType(fileName, rollType);
        return new FileAppenderDefinition(fileName);
    }
}

