/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.appender.file;

import java.io.File;
import org.fabric3.monitor.appender.file.RollStrategy;

public class SizeRollStrategy
implements RollStrategy {
    private long size;
    private int maxBackups = -1;
    private int counter = 1;

    public SizeRollStrategy(long size, int maxBackups) {
        this.size = size;
        this.maxBackups = maxBackups;
    }

    @Override
    public boolean checkRoll(File file) {
        return file.length() >= this.size;
    }

    @Override
    public File getBackup(File file) {
        File backup;
        if (this.maxBackups > 0) {
            this.rotateBackups(file);
        }
        while ((backup = this.getLogName(file, this.counter)).exists()) {
            ++this.counter;
        }
        return backup;
    }

    private void rotateBackups(File file) {
        if (this.counter >= this.maxBackups) {
            this.getLogName(file, 1).delete();
            int current = 1;
            while (current < this.counter) {
                File target = this.getLogName(file, current);
                File source = this.getLogName(file, ++current);
                source.renameTo(target);
            }
            this.counter = 1;
        }
    }

    private File getLogName(File file, int counter) {
        int pos = file.getName().lastIndexOf(".");
        if (pos < 0) {
            return new File(file.getParent(), file.getName() + counter);
        }
        String name = file.getName().substring(0, pos) + counter;
        String extension = file.getName().substring(pos);
        return new File(file.getParent(), name + extension);
    }
}

