/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.builder;

import java.util.ArrayList;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.monitor.impl.destination.DefaultMonitorDestination;
import org.fabric3.monitor.impl.model.physical.PhysicalDefaultMonitorDestination;
import org.fabric3.monitor.spi.appender.Appender;
import org.fabric3.monitor.spi.appender.AppenderBuilder;
import org.fabric3.monitor.spi.destination.MonitorDestination;
import org.fabric3.monitor.spi.destination.MonitorDestinationBuilder;
import org.fabric3.monitor.spi.destination.MonitorDestinationRegistry;
import org.fabric3.monitor.spi.model.physical.PhysicalAppender;
import org.fabric3.monitor.spi.writer.EventWriter;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DefaultMonitorDestinationBuilder
implements MonitorDestinationBuilder<PhysicalDefaultMonitorDestination> {
    private MonitorDestinationRegistry registry;
    private EventWriter eventWriter;
    private int capacity = 1024;
    private Map<Class<?>, AppenderBuilder<?>> appenderBuilders;

    @Reference
    public void setAppenderBuilders(Map<Class<?>, AppenderBuilder<?>> appenderBuilders) {
        this.appenderBuilders = appenderBuilders;
    }

    @Property(required=false)
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public DefaultMonitorDestinationBuilder(@Reference MonitorDestinationRegistry registry, @Reference EventWriter eventWriter) {
        this.registry = registry;
        this.eventWriter = eventWriter;
    }

    @Override
    public void build(PhysicalDefaultMonitorDestination physicalDestination) throws Fabric3Exception {
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        for (PhysicalAppender physicalAppender : physicalDestination.getPhysicalAppenders()) {
            AppenderBuilder<?> builder = this.appenderBuilders.get(physicalAppender.getClass());
            if (builder == null) {
                throw new Fabric3Exception("Unknown appender type: " + physicalDestination.getClass());
            }
            Appender appender = builder.build(physicalAppender);
            appenders.add(appender);
        }
        String name = physicalDestination.getName();
        DefaultMonitorDestination destination = new DefaultMonitorDestination(name, this.eventWriter, this.capacity, appenders);
        destination.start();
        this.registry.register(destination);
    }

    @Override
    public void remove(PhysicalDefaultMonitorDestination physicalDestination) throws Fabric3Exception {
        MonitorDestination destination = this.registry.unregister(physicalDestination.getName());
        destination.stop();
    }
}

