/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.builder;

import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.monitor.spi.destination.MonitorDestinationBuilder;
import org.fabric3.monitor.spi.model.physical.PhysicalMonitor;
import org.fabric3.monitor.spi.model.physical.PhysicalMonitorDestination;
import org.fabric3.spi.container.builder.ResourceBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class MonitorBuilder
implements ResourceBuilder<PhysicalMonitor> {
    private Map<Class<?>, MonitorDestinationBuilder<?>> builders;

    @Reference
    public void setBuilders(Map<Class<?>, MonitorDestinationBuilder<?>> builders) {
        this.builders = builders;
    }

    @Override
    public void build(PhysicalMonitor physicalMonitor) {
        PhysicalMonitorDestination destination = physicalMonitor.getDestination();
        MonitorDestinationBuilder builder = this.getBuilder(destination);
        builder.build(destination);
    }

    @Override
    public void remove(PhysicalMonitor physicalMonitor) {
        PhysicalMonitorDestination destination = physicalMonitor.getDestination();
        MonitorDestinationBuilder builder = this.getBuilder(destination);
        builder.remove(destination);
    }

    private MonitorDestinationBuilder getBuilder(PhysicalMonitorDestination destinationDefinition) {
        MonitorDestinationBuilder<?> builder = this.builders.get(destinationDefinition.getClass());
        if (builder == null) {
            throw new Fabric3Exception("Unknown destination type: " + destinationDefinition.getClass().getName());
        }
        return builder;
    }
}

