/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.destination;

import java.nio.ByteBuffer;
import java.util.List;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.monitor.spi.appender.Appender;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;
import org.fabric3.monitor.spi.destination.MonitorDestination;
import org.fabric3.monitor.spi.event.MonitorEventEntry;
import org.fabric3.monitor.spi.writer.EventWriter;

public class DefaultMonitorDestination
implements MonitorDestination {
    private static final byte[] NEWLINE = "\n".getBytes();
    private String name;
    private EventWriter eventWriter;
    private Appender[] appenders;
    private int capacity;

    public DefaultMonitorDestination(String name, EventWriter eventWriter, int capacity, List<Appender> appenders) {
        this.name = name;
        this.eventWriter = eventWriter;
        this.capacity = capacity;
        this.appenders = appenders.toArray(new Appender[appenders.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start() {
        for (Appender appender : this.appenders) {
            appender.start();
        }
    }

    @Override
    public void stop() {
        for (Appender appender : this.appenders) {
            appender.stop();
        }
    }

    @Override
    public void write(MonitorEventEntry entry) {
        ResizableByteBuffer buffer = entry.getBuffer();
        MonitorLevel level = entry.getLevel();
        long entryTimestamp = entry.getEntryTimestamp();
        int count = this.eventWriter.writePrefix(level, entryTimestamp, buffer);
        count += this.eventWriter.writeTemplate(entry);
        buffer.put(NEWLINE);
        buffer.limit(++count);
        this.write(buffer);
    }

    @Override
    public void write(MonitorLevel level, long timestamp, String source, String template, Object ... args) {
        ByteBuffer buffer = ByteBuffer.allocate(this.capacity);
        ResizableByteBuffer wrapper = new ResizableByteBuffer(buffer);
        this.eventWriter.write(level, timestamp, template, wrapper, args);
        this.write(wrapper);
    }

    private void write(ResizableByteBuffer buffer) {
        for (Appender appender : this.appenders) {
            buffer.position(0);
            appender.write(buffer.getByteBuffer());
        }
    }
}

