/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.destination;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.monitor.spi.destination.MonitorDestination;
import org.fabric3.monitor.spi.destination.MonitorDestinationRegistry;
import org.fabric3.monitor.spi.event.MonitorEventEntry;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.runtime.event.RuntimeDestroyed;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class MonitorDestinationRegistryImpl
implements MonitorDestinationRegistry {
    private AtomicReference<MonitorDestination[]> destinations;
    private EventService eventService;

    public MonitorDestinationRegistryImpl(@Reference EventService eventService) {
        this.eventService = eventService;
    }

    @Init
    public void init() throws IOException {
        this.destinations = new AtomicReference();
        this.destinations.set(new MonitorDestination[0]);
        this.eventService.subscribe(RuntimeDestroyed.class, new MonitorEventListener());
    }

    @Override
    public synchronized void register(MonitorDestination destination) {
        MonitorDestination[] source = this.destinations.get();
        MonitorDestination[] target = new MonitorDestination[source.length + 1];
        System.arraycopy(source, 0, target, 0, source.length);
        target[target.length - 1] = destination;
        this.destinations.lazySet(target);
    }

    @Override
    public MonitorDestination unregister(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndex(String name) {
        MonitorDestination[] copy = this.destinations.get();
        for (int i = 0; i < copy.length; ++i) {
            MonitorDestination destination = copy[i];
            if (!destination.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void write(MonitorEventEntry entry) throws IOException {
        int index = entry.getDestinationIndex();
        this.checkIndex(index);
        this.destinations.get()[index].write(entry);
    }

    @Override
    public void write(int index, MonitorLevel level, long timestamp, String source, String template, Object ... args) throws IOException {
        this.checkIndex(index);
        this.destinations.get()[index].write(level, timestamp, source, template, args);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.destinations.get().length) {
            throw new AssertionError((Object)("Invalid index: " + index));
        }
    }

    private void stop() throws IOException {
        MonitorDestination[] copy;
        for (MonitorDestination destination : copy = this.destinations.get()) {
            destination.stop();
        }
    }

    private class MonitorEventListener
    implements Fabric3EventListener<RuntimeDestroyed> {
        private MonitorEventListener() {
        }

        @Override
        public void onEvent(RuntimeDestroyed event) {
            try {
                MonitorDestinationRegistryImpl.this.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

