/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.extension;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.annotation.monitor.Severe;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.monitor.impl.destination.DefaultMonitorDestination;
import org.fabric3.monitor.impl.router.RingBufferDestinationRouter;
import org.fabric3.monitor.spi.appender.Appender;
import org.fabric3.monitor.spi.appender.AppenderFactory;
import org.fabric3.monitor.spi.destination.MonitorDestinationRegistry;
import org.fabric3.monitor.spi.writer.EventWriter;
import org.fabric3.spi.xml.LocationAwareXMLStreamReader;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ExtensionProvider {
    private MonitorDestinationRegistry registry;
    private EventWriter eventWriter;
    private AppenderFactory appenderFactory;
    private ExtensionProviderMonitor monitor;
    private int capacity = 1024;
    private boolean overrideDefault;
    private LocationAwareXMLStreamReader systemReader;

    @Property(required=false)
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Property(required=false)
    public void setOverrideDefault(boolean overrideDefault) {
        this.overrideDefault = overrideDefault;
    }

    @Property(required=false)
    public void setDefaultAppenders(XMLStreamReader reader) {
        this.systemReader = new LocationAwareXMLStreamReader(reader, "system configuration");
    }

    public ExtensionProvider(@Reference MonitorDestinationRegistry registry, @Reference EventWriter eventWriter, @Reference AppenderFactory appenderFactory, @Reference RingBufferDestinationRouter router, @Monitor ExtensionProviderMonitor monitor) {
        this.registry = registry;
        this.eventWriter = eventWriter;
        this.appenderFactory = appenderFactory;
        this.monitor = monitor;
    }

    @Init
    public void init() {
        try {
            if (this.overrideDefault) {
                return;
            }
            List<Appender> defaultAppenders = this.systemReader == null ? this.appenderFactory.instantiateDefaultAppenders() : this.appenderFactory.instantiate(this.systemReader);
            DefaultMonitorDestination defaultDestination = new DefaultMonitorDestination("default", this.eventWriter, this.capacity, defaultAppenders);
            defaultDestination.start();
            this.registry.register(defaultDestination);
            this.systemReader = null;
        }
        catch (Fabric3Exception e) {
            this.monitor.error(e);
        }
    }

    public static interface ExtensionProviderMonitor {
        @Severe
        public void error(Throwable var1);
    }
}

