/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.generator;

import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.monitor.impl.model.physical.PhysicalDefaultMonitorDestination;
import org.fabric3.monitor.impl.model.type.DefaultMonitorDestinationDefinition;
import org.fabric3.monitor.spi.appender.AppenderGenerator;
import org.fabric3.monitor.spi.destination.MonitorDestinationGenerator;
import org.fabric3.monitor.spi.model.physical.PhysicalAppender;
import org.fabric3.monitor.spi.model.type.AppenderDefinition;
import org.fabric3.monitor.spi.model.type.MonitorResource;
import org.oasisopen.sca.annotation.Reference;

public class DefaultMonitorDestinationGenerator
implements MonitorDestinationGenerator<DefaultMonitorDestinationDefinition> {
    private Map<Class<?>, AppenderGenerator<?>> appenderGenerators;

    @Reference
    public void setAppenderGenerators(Map<Class<?>, AppenderGenerator<?>> appenderGenerators) {
        this.appenderGenerators = appenderGenerators;
    }

    public PhysicalDefaultMonitorDestination generateResource(DefaultMonitorDestinationDefinition physicalDestination) throws Fabric3Exception {
        String name = ((MonitorResource)physicalDestination.getParent()).getName();
        PhysicalDefaultMonitorDestination physicalDefinition = new PhysicalDefaultMonitorDestination(name);
        List<AppenderDefinition> appenderDefinitions = physicalDestination.getAppenderDefinitions();
        for (AppenderDefinition appenderDefinition : appenderDefinitions) {
            AppenderGenerator generator = this.getAppenderGenerator(appenderDefinition);
            PhysicalAppender physicalAppender = generator.generateResource(appenderDefinition);
            physicalDefinition.add(physicalAppender);
        }
        return physicalDefinition;
    }

    private AppenderGenerator getAppenderGenerator(AppenderDefinition definition) throws Fabric3Exception {
        AppenderGenerator<?> generator = this.appenderGenerators.get(definition.getClass());
        if (generator == null) {
            throw new Fabric3Exception("Unknown appender type: " + definition.getClass());
        }
        return generator;
    }
}

