/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.generator;

import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.monitor.spi.destination.MonitorDestinationGenerator;
import org.fabric3.monitor.spi.model.physical.PhysicalMonitor;
import org.fabric3.monitor.spi.model.physical.PhysicalMonitorDestination;
import org.fabric3.monitor.spi.model.type.MonitorDestinationDefinition;
import org.fabric3.monitor.spi.model.type.MonitorResource;
import org.fabric3.spi.domain.generator.ResourceGenerator;
import org.fabric3.spi.model.instance.LogicalResource;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class MonitorResourceGenerator
implements ResourceGenerator<MonitorResource> {
    private Map<Class<?>, MonitorDestinationGenerator<?>> destinationGenerators;

    @Reference
    public void setDestinationGenerators(Map<Class<?>, MonitorDestinationGenerator<?>> destinationGenerators) {
        this.destinationGenerators = destinationGenerators;
    }

    public PhysicalMonitor generateResource(LogicalResource<MonitorResource> logicalResource) throws Fabric3Exception {
        MonitorResource resourceDefinition = logicalResource.getDefinition();
        PhysicalMonitor physicalMonitor = new PhysicalMonitor(resourceDefinition.getName());
        MonitorDestinationDefinition destinationDefinition = resourceDefinition.getDestinationDefinition();
        MonitorDestinationGenerator generator = this.getDestinationGenerator(destinationDefinition);
        PhysicalMonitorDestination destination = generator.generateResource(destinationDefinition);
        physicalMonitor.setDestination(destination);
        return physicalMonitor;
    }

    private MonitorDestinationGenerator getDestinationGenerator(MonitorDestinationDefinition definition) throws Fabric3Exception {
        MonitorDestinationGenerator<?> generator = this.destinationGenerators.get(definition.getClass());
        if (generator == null) {
            throw new Fabric3Exception("Unknown monitor destination type: " + definition.getClass());
        }
        return generator;
    }
}

