/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.introspection;

import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.monitor.impl.model.type.DefaultMonitorDestinationDefinition;
import org.fabric3.monitor.spi.model.type.AppenderDefinition;
import org.fabric3.monitor.spi.model.type.MonitorResource;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class MonitorResourceLoader
extends AbstractValidatingTypeLoader<MonitorResource> {
    private static final QName SCA_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "monitor");
    private static final QName F3_TYPE = new QName("urn:fabric3.org", "monitor");
    private LoaderRegistry registry;

    public MonitorResourceLoader(@Reference LoaderRegistry registry) {
        this.registry = registry;
        this.addAttributes("name");
    }

    @Init
    public void init() {
        this.registry.registerLoader(F3_TYPE, this);
        this.registry.registerLoader(SCA_TYPE, this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregisterLoader(F3_TYPE);
        this.registry.unregisterLoader(SCA_TYPE);
    }

    @Override
    public MonitorResource load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MonitorResource definition = new MonitorResource("");
            MissingAttribute error = new MissingAttribute("A monitor name must be specified", reader.getLocation(), definition);
            context.addError(error);
            return definition;
        }
        MonitorResource definition = new MonitorResource(name);
        DefaultMonitorDestinationDefinition destinationDefinition = new DefaultMonitorDestinationDefinition();
        definition.setDestinationDefinition(destinationDefinition);
        HashSet<String> definedTypes = new HashSet<String>();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().startsWith("appender.")) break;
                    ModelObject modelObject = this.registry.load(reader, ModelObject.class, context);
                    if (modelObject instanceof AppenderDefinition) {
                        AppenderDefinition appenderDefinition = (AppenderDefinition)modelObject;
                        String type = appenderDefinition.getType();
                        if (definedTypes.contains(type)) {
                            Location location = reader.getLocation();
                            context.addError(new InvalidValue("Multiple appenders defined with type:" + type, location, definition));
                            break;
                        }
                        definedTypes.add(type);
                        destinationDefinition.add(appenderDefinition);
                        break;
                    }
                    throw new AssertionError((Object)("Unexpected type: " + modelObject));
                }
                case 2: {
                    if (!"monitor".equals(reader.getName().getLocalPart())) break;
                    return definition;
                }
                case 8: {
                    throw new AssertionError((Object)"End of document encountered");
                }
            }
        }
    }
}

