/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.proxy;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.monitor.MonitorProxyServiceExtension;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.monitor.impl.router.RingBufferDestinationRouter;
import org.fabric3.spi.monitor.DispatchInfo;
import org.fabric3.spi.monitor.MonitorUtil;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;

@EagerInit
public abstract class AbstractMonitorProxyService
implements MonitorProxyServiceExtension {
    protected Monitorable defaultMonitorable;
    protected RingBufferDestinationRouter router;
    protected boolean enabled = false;
    protected String pattern = "%d:%m:%Y %H:%i:%s.%F";
    protected TimeZone timeZone = TimeZone.getDefault();

    public AbstractMonitorProxyService(RingBufferDestinationRouter router, Monitorable monitorable) {
        this.defaultMonitorable = monitorable;
        this.router = router;
    }

    @Property(required=false)
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public <T> T createMonitor(Class<T> type) throws Fabric3Exception {
        return this.createMonitor(type, this.defaultMonitorable, "default");
    }

    protected <T> DispatchInfo createDispatchInfo(Class<T> type, ClassLoader loader, Method method) {
        DispatchInfo info = MonitorUtil.getDispatchInfo(method);
        String message = info.getMessage();
        if (Locale.ENGLISH.getLanguage().equals(Locale.getDefault().getLanguage())) {
            if (message.length() > 0) {
                return info;
            }
            if (message.length() == 0) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length == 1 && String.class.equals(types[0])) {
                    info.setMessage("{0}");
                    return info;
                }
                if (types.length == 2 && String.class.equals(types[0]) && Throwable.class.isAssignableFrom(types[1])) {
                    info.setMessage("{0}");
                    return info;
                }
            }
        }
        String key = type.getName() + "#" + method.getName();
        ResourceBundle bundle = this.locateBundle(type, loader);
        if (bundle != null) {
            try {
                message = bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (message.length() == 0 && method.getParameterTypes().length == 0) {
            message = key;
        }
        info.setMessage(message);
        return info;
    }

    protected <T> ResourceBundle locateBundle(Class<T> monitorInterface, ClassLoader loader) {
        Locale locale = Locale.getDefault();
        String packageName = monitorInterface.getPackage().getName();
        while (true) {
            try {
                return ResourceBundle.getBundle(packageName + ".f3", locale, loader);
            }
            catch (MissingResourceException missingResourceException) {
                int index = packageName.lastIndexOf(46);
                if (index != -1) {
                    packageName = packageName.substring(0, index);
                    continue;
                }
                try {
                    return ResourceBundle.getBundle("f3", locale, loader);
                }
                catch (Exception e) {
                    return null;
                }
            }
            break;
        }
    }
}

