/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.monitor.MonitorProxyServiceExtension;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.monitor.impl.proxy.AbstractMonitorHandler;
import org.fabric3.monitor.impl.proxy.AbstractMonitorProxyService;
import org.fabric3.monitor.impl.router.RingBufferDestinationRouter;
import org.fabric3.monitor.spi.event.MonitorEventEntry;
import org.fabric3.monitor.spi.event.ParameterEntry;
import org.fabric3.spi.classloader.BytecodeClassLoader;
import org.fabric3.spi.monitor.DispatchInfo;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

@Service(value={MonitorProxyServiceExtension.class})
public class BytecodeMonitorProxyService
extends AbstractMonitorProxyService
implements Opcodes {
    public static final String PARAM_ENTRY = Type.getInternalName(ParameterEntry.class);
    public static final String MONITOR_EVENT_ENTRY = Type.getInternalName(MonitorEventEntry.class);
    public static final String ABSTRACT_MONITOR_HANDLER = Type.getInternalName(AbstractMonitorHandler.class);
    public static final String DISPATCH_INFO = Type.getInternalName(DispatchInfo.class);
    public static final String MONITOR_LEVEL = Type.getInternalName(MonitorLevel.class);
    public static final String DESTINATION_ROUTER = Type.getInternalName(RingBufferDestinationRouter.class);

    public BytecodeMonitorProxyService(@Reference RingBufferDestinationRouter router, @Reference Monitorable monitorable) {
        super(router, monitorable);
    }

    @Override
    public <T> T createMonitor(Class<T> type, Monitorable monitorable, String destination) throws Fabric3Exception {
        Method[] methods;
        if (destination == null) {
            destination = "default";
        }
        String proxyClassName = type.getName().replace("$", "") + "_Proxy";
        int destinationIndex = this.router.getDestinationIndex(destination);
        ClassLoader loader = type.getClassLoader();
        LinkedHashMap<Method, DispatchInfo> levels = new LinkedHashMap<Method, DispatchInfo>();
        for (Method method : methods = type.getMethods()) {
            DispatchInfo info = this.createDispatchInfo(type, loader, method);
            levels.put(method, info);
        }
        byte[] classBytes = this.generateClass(type, 2);
        BytecodeClassLoader bytecodeClassLoader = this.getClassLoader(type);
        Class<?> clazz = bytecodeClassLoader.defineClass(proxyClassName, classBytes);
        try {
            Collection values = levels.values();
            DispatchInfo[] infos = values.toArray(new DispatchInfo[values.size()]);
            AbstractMonitorHandler handler = (AbstractMonitorHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            handler.init(destinationIndex, monitorable, this.router, infos, this.enabled);
            return type.cast(handler);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Fabric3Exception(e);
        }
    }

    <T> byte[] generateClass(Class<T> type, int flags) {
        String proxyClassNameInternal = Type.getInternalName(type).replace("$", "") + "_Proxy";
        String proxyClassDescriptor = "L" + proxyClassNameInternal + ";";
        String interfazeName = Type.getInternalName(type);
        ClassWriter cw = new ClassWriter(flags);
        cw.visit(51, 33, proxyClassNameInternal, null, ABSTRACT_MONITOR_HANDLER, new String[]{interfazeName});
        cw.visitSource(type.getName() + "Proxy.java", null);
        if (type.isLocalClass()) {
            String enclosingName = Type.getInternalName(type.getEnclosingClass());
            cw.visitInnerClass(interfazeName, enclosingName, type.getSimpleName(), 1545);
        }
        this.writeConstructor(cw, proxyClassDescriptor);
        Method[] methods = type.getMethods();
        int index = 0;
        for (Method method : methods) {
            String signature = this.calculateWriteParametersSignature(method);
            Class<?>[] parameterTypes = method.getParameterTypes();
            this.generateMethod(cw, method, index, proxyClassNameInternal, signature);
            this.writeGenerateParametersMethod(cw, index, signature, parameterTypes);
            ++index;
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateMethod(ClassWriter cw, Method method, int index, String proxyClassNameInternal, String writeParametersSignature) {
        String methodSignature = Type.getMethodDescriptor(method);
        Class<?>[] paramTypes = method.getParameterTypes();
        int numParams = paramTypes.length;
        int offset = this.calculateParameterSpace(paramTypes);
        int varIndexPosition = offset + 1;
        int varCurrentLevelPosition = varIndexPosition + 1;
        int varCurrentMessagePosition = varCurrentLevelPosition + 1;
        int varTimestampPosition = varCurrentMessagePosition + 1;
        int varDispatchInfoPosition = varCurrentMessagePosition + 1;
        int varEntryPosition = varTimestampPosition + 2;
        int varArgsPosition = varTimestampPosition + 2;
        int varStartPosition = varEntryPosition + 1;
        int varBufferPosition = varStartPosition + 2;
        MethodVisitor mv = cw.visitMethod(1, method.getName(), methodSignature, null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, null);
        Label l3 = new Label();
        mv.visitTryCatchBlock(l2, l3, l2, null);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLineNumber(62, l4);
        this.pushInteger(index, mv);
        mv.visitVarInsn(54, varIndexPosition);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitLineNumber(65, l5);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "infos", "[L" + DISPATCH_INFO + ";");
        mv.visitVarInsn(21, varIndexPosition);
        mv.visitInsn(50);
        mv.visitVarInsn(58, varDispatchInfoPosition);
        Label l11 = new Label();
        mv.visitLabel(l11);
        mv.visitLineNumber(70, l11);
        mv.visitVarInsn(25, varDispatchInfoPosition);
        mv.visitMethodInsn(182, DISPATCH_INFO, "getLevel", "()L" + MONITOR_LEVEL + ";");
        mv.visitVarInsn(58, varCurrentLevelPosition);
        Label l12 = new Label();
        mv.visitLabel(l12);
        mv.visitLineNumber(71, l12);
        mv.visitVarInsn(25, varDispatchInfoPosition);
        mv.visitMethodInsn(182, DISPATCH_INFO, "getMessage", "()Ljava/lang/String;");
        mv.visitVarInsn(58, varCurrentMessagePosition);
        mv.visitVarInsn(25, varCurrentLevelPosition);
        Label l13 = new Label();
        mv.visitJumpInsn(198, l13);
        mv.visitVarInsn(25, varCurrentLevelPosition);
        mv.visitMethodInsn(182, MONITOR_LEVEL, "intValue", "()I");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "monitorable", "Lorg/fabric3/api/host/monitor/Monitorable;");
        mv.visitMethodInsn(185, "org/fabric3/api/host/monitor/Monitorable", "getLevel", "()L" + MONITOR_LEVEL + ";");
        mv.visitMethodInsn(182, MONITOR_LEVEL, "intValue", "()I");
        Label l14 = new Label();
        mv.visitJumpInsn(162, l14);
        mv.visitLabel(l13);
        mv.visitLineNumber(75, l13);
        mv.visitInsn(177);
        mv.visitLabel(l14);
        mv.visitLineNumber(77, l14);
        mv.visitMethodInsn(184, "java/lang/System", "currentTimeMillis", "()J");
        mv.visitVarInsn(55, varTimestampPosition);
        Label l15 = new Label();
        mv.visitLabel(l15);
        mv.visitLineNumber(78, l15);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "asyncEnabled", "Z");
        Label l16 = new Label();
        mv.visitJumpInsn(153, l16);
        Label l17 = new Label();
        mv.visitLabel(l17);
        mv.visitLineNumber(79, l17);
        mv.visitInsn(1);
        mv.visitVarInsn(58, varArgsPosition);
        mv.visitLabel(l0);
        mv.visitLineNumber(81, l0);
        mv.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J");
        mv.visitVarInsn(55, varStartPosition);
        Label l18 = new Label();
        mv.visitLabel(l18);
        mv.visitLineNumber(82, l18);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "router", "L" + DESTINATION_ROUTER + ";");
        mv.visitMethodInsn(185, DESTINATION_ROUTER, "get", "()L" + MONITOR_EVENT_ENTRY + ";");
        mv.visitVarInsn(58, varEntryPosition);
        Label l19 = new Label();
        mv.visitLabel(l19);
        mv.visitLineNumber(83, l19);
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "destinationIndex", "I");
        mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "setDestinationIndex", "(I)V");
        Label l20 = new Label();
        mv.visitLabel(l20);
        mv.visitLineNumber(84, l20);
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitVarInsn(22, varStartPosition);
        mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "setTimestampNanos", "(J)V");
        Label l21 = new Label();
        mv.visitLabel(l21);
        mv.visitLineNumber(85, l21);
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "getBuffer", "()Lorg/fabric3/monitor/spi/buffer/ResizableByteBuffer;");
        mv.visitVarInsn(58, varBufferPosition);
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitVarInsn(25, varCurrentMessagePosition);
        mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "setTemplate", "(Ljava/lang/String;)V");
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitMethodInsn(184, "java/lang/System", "currentTimeMillis", "()J");
        mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "setEntryTimestamp", "(J)V");
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitVarInsn(25, varCurrentLevelPosition);
        mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "setLevel", "(L" + MONITOR_LEVEL + ";)V");
        Label l22 = new Label();
        mv.visitLabel(l22);
        mv.visitLineNumber(87, l22);
        mv.visitVarInsn(25, 0);
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (paramType.isPrimitive()) {
                if (Integer.TYPE.equals(paramType)) {
                    mv.visitVarInsn(21, i + 1);
                    continue;
                }
                if (Long.TYPE.equals(paramType)) {
                    mv.visitVarInsn(22, i + 1);
                    continue;
                }
                if (Double.TYPE.equals(paramType)) {
                    mv.visitVarInsn(24, i + 1);
                    continue;
                }
                if (Boolean.TYPE.equals(paramType)) {
                    mv.visitVarInsn(21, i + 1);
                    continue;
                }
                if (Float.TYPE.equals(paramType)) {
                    mv.visitVarInsn(23, i + 1);
                    continue;
                }
                if (Short.TYPE.equals(paramType)) {
                    mv.visitVarInsn(21, i + 1);
                    continue;
                }
                if (Byte.TYPE.equals(paramType)) {
                    mv.visitVarInsn(21, i + 1);
                    continue;
                }
                if (Character.TYPE.equals(paramType)) {
                    mv.visitVarInsn(21, i + 1);
                    continue;
                }
                throw new AssertionError((Object)("Unhandled type: " + paramType));
            }
            mv.visitVarInsn(25, i + 1);
        }
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitMethodInsn(183, proxyClassNameInternal, "writeParameters" + index, writeParametersSignature);
        Label l24 = new Label();
        mv.visitLabel(l24);
        mv.visitLineNumber(90, l24);
        mv.visitLabel(l1);
        mv.visitLineNumber(95, l1);
        mv.visitVarInsn(25, varEntryPosition);
        Label l27 = new Label();
        mv.visitJumpInsn(198, l27);
        Label l28 = new Label();
        mv.visitLabel(l28);
        mv.visitLineNumber(96, l28);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "router", "L" + DESTINATION_ROUTER + ";");
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitMethodInsn(185, DESTINATION_ROUTER, "publish", "(L" + MONITOR_EVENT_ENTRY + ";)V");
        mv.visitJumpInsn(167, l27);
        mv.visitLabel(l2);
        mv.visitLineNumber(95, l2);
        mv.visitVarInsn(58, 13);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, varEntryPosition);
        Label l29 = new Label();
        mv.visitJumpInsn(198, l29);
        Label l30 = new Label();
        mv.visitLabel(l30);
        mv.visitLineNumber(96, l30);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "router", "L" + DESTINATION_ROUTER + ";");
        mv.visitVarInsn(25, varArgsPosition);
        mv.visitMethodInsn(185, DESTINATION_ROUTER, "publish", "(L" + MONITOR_EVENT_ENTRY + ";)V");
        mv.visitLabel(l29);
        mv.visitVarInsn(25, 13);
        mv.visitInsn(191);
        mv.visitLabel(l27);
        mv.visitLineNumber(99, l27);
        Label l31 = new Label();
        mv.visitJumpInsn(167, l31);
        mv.visitLabel(l16);
        mv.visitLineNumber(100, l16);
        this.pushInteger(numParams, mv);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitVarInsn(58, varArgsPosition);
        Label l32 = new Label();
        mv.visitLabel(l32);
        mv.visitLineNumber(101, l32);
        for (int i = 0; i < paramTypes.length; ++i) {
            mv.visitVarInsn(25, varArgsPosition);
            this.pushInteger(i, mv);
            if (paramTypes[i].isPrimitive()) {
                if (Integer.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(21, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                } else if (Long.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(22, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                } else if (Double.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(24, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                } else if (Float.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(23, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                } else if (Boolean.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(21, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(Z)Ljava/lang/Boolean;");
                } else if (Short.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(21, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                } else if (Byte.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(21, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                } else if (Character.TYPE.equals(paramTypes[i])) {
                    mv.visitVarInsn(21, i + 1);
                    mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                }
            } else {
                mv.visitVarInsn(25, i + 1);
            }
            mv.visitInsn(83);
        }
        Label l34 = new Label();
        mv.visitLabel(l34);
        mv.visitLineNumber(103, l34);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "router", "L" + DESTINATION_ROUTER + ";");
        mv.visitVarInsn(25, varCurrentLevelPosition);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "destinationIndex", "I");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "runtimeName", "Ljava/lang/String;");
        mv.visitVarInsn(22, varTimestampPosition);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ABSTRACT_MONITOR_HANDLER, "source", "Ljava/lang/String;");
        mv.visitVarInsn(25, varCurrentMessagePosition);
        mv.visitVarInsn(25, varArgsPosition);
        mv.visitMethodInsn(185, DESTINATION_ROUTER, "send", "(Lorg/fabric3/api/annotation/monitor/MonitorLevel;ILjava/lang/String;JLjava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V");
        mv.visitLabel(l31);
        mv.visitLineNumber(106, l31);
        mv.visitInsn(177);
        Label methodEnd = new Label();
        mv.visitLabel(methodEnd);
        mv.visitLocalVariable("this", "Lorg/fabric3/monitor/impl/proxy/AbstractMonitorHandler;", null, l4, methodEnd, 0);
        for (int i = 1; i <= numParams; ++i) {
            Class<?> paramType = paramTypes[i - 1];
            if (String.class.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "Ljava/lang/String;", null, l4, methodEnd, i);
                continue;
            }
            if (Integer.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "I", null, l4, methodEnd, i);
                continue;
            }
            if (Long.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "J", null, l4, methodEnd, i);
                continue;
            }
            if (Double.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "D", null, l4, methodEnd, i);
                continue;
            }
            if (Boolean.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "Z", null, l4, methodEnd, i);
                continue;
            }
            if (Float.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "F", null, l4, methodEnd, i);
                continue;
            }
            if (Short.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "S", null, l4, methodEnd, i);
                continue;
            }
            if (Byte.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "B", null, l4, methodEnd, i);
                continue;
            }
            if (Character.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "C", null, l4, methodEnd, i);
                continue;
            }
            if (paramType.isPrimitive()) {
                throw new AssertionError((Object)("Unhandled type: " + paramType));
            }
            mv.visitLocalVariable("arg" + i, "Ljava/lang/Object;", null, l4, methodEnd, i);
        }
        mv.visitLocalVariable("index", "I", null, l5, methodEnd, varIndexPosition);
        mv.visitLocalVariable("currentLevel", "L" + MONITOR_LEVEL + ";", null, l12, methodEnd, varCurrentLevelPosition);
        mv.visitLocalVariable("currentMessage", "Ljava/lang/String;", null, l12, methodEnd, varCurrentMessagePosition);
        mv.visitLocalVariable("timestamp", "J", null, l15, methodEnd, varTimestampPosition);
        mv.visitLocalVariable("info", "L" + DISPATCH_INFO + ";", null, l11, l12, varDispatchInfoPosition);
        mv.visitLocalVariable("entry", "L" + MONITOR_EVENT_ENTRY + ";", null, l0, l27, varEntryPosition);
        mv.visitLocalVariable("args", "[Ljava/lang/Object;", null, l32, l31, varArgsPosition);
        mv.visitLocalVariable("start", "J", null, l18, l1, varStartPosition);
        mv.visitLocalVariable("buffer", "Lorg/fabric3/monitor/spi/buffer/ResizableByteBuffer;", null, l22, l1, varBufferPosition);
        mv.visitMaxs(9, 14);
        mv.visitEnd();
    }

    private void writeGenerateParametersMethod(ClassWriter cw, int index, String signature, Class<?>[] paramTypes) {
        int varMethodArgOffset = 1;
        int offset = this.calculateParameterSpace(paramTypes);
        int varEntryPosition = offset + 1;
        int varNumberArgsPosition = varEntryPosition + 1;
        int varParamEntryPosition = varNumberArgsPosition + 1;
        int varIPosition = varParamEntryPosition + 1;
        MethodVisitor mv = cw.visitMethod(2, "writeParameters" + index, signature, null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(103, l0);
        this.pushInteger(paramTypes.length, mv);
        mv.visitVarInsn(54, varNumberArgsPosition);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(104, l1);
        mv.visitVarInsn(25, varEntryPosition);
        mv.visitVarInsn(21, varNumberArgsPosition);
        mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "setLimit", "(I)V");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(112, l2);
        mv.visitInsn(3);
        mv.visitVarInsn(54, varIPosition);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitVarInsn(21, varIPosition);
        mv.visitVarInsn(21, varNumberArgsPosition);
        Label l4 = new Label();
        mv.visitJumpInsn(162, l4);
        Label endIf = new Label();
        for (int i = 0; i < paramTypes.length; ++i) {
            mv.visitVarInsn(25, varEntryPosition);
            mv.visitMethodInsn(182, MONITOR_EVENT_ENTRY, "getEntries", "()[L" + PARAM_ENTRY + ";");
            this.pushInteger(i, mv);
            mv.visitInsn(50);
            mv.visitVarInsn(58, varParamEntryPosition);
            mv.visitVarInsn(25, varParamEntryPosition);
            Class<?> paramType = paramTypes[i];
            if (Character.TYPE.equals(paramType)) {
                mv.visitVarInsn(21, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setCharValue", "(C)V");
                continue;
            }
            if (Integer.TYPE.equals(paramType)) {
                mv.visitVarInsn(21, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setIntValue", "(I)V");
                continue;
            }
            if (Long.TYPE.equals(paramType)) {
                mv.visitVarInsn(22, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setLongValue", "(J)V");
                continue;
            }
            if (Double.TYPE.equals(paramType)) {
                mv.visitVarInsn(24, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setDoubleValue", "(D)V");
                continue;
            }
            if (Boolean.TYPE.equals(paramType)) {
                mv.visitVarInsn(21, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setBooleanValue", "(Z)V");
                continue;
            }
            if (Float.TYPE.equals(paramType)) {
                mv.visitVarInsn(23, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setFloatValue", "(F)V");
                continue;
            }
            if (Short.TYPE.equals(paramType)) {
                mv.visitVarInsn(21, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setShortValue", "(S)V");
                continue;
            }
            if (Byte.TYPE.equals(paramType)) {
                mv.visitVarInsn(21, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setByteValue", "(B)V");
                continue;
            }
            if (Object.class.isAssignableFrom(paramType)) {
                mv.visitVarInsn(25, varMethodArgOffset + i);
                mv.visitMethodInsn(182, PARAM_ENTRY, "setObjectValue", "(Ljava/lang/Object;)V");
                continue;
            }
            throw new AssertionError((Object)("Unhandled type: " + paramType));
        }
        mv.visitLabel(endIf);
        mv.visitLineNumber(121, endIf);
        mv.visitIincInsn(varIPosition, 1);
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l4);
        mv.visitInsn(177);
        Label endMethod = new Label();
        mv.visitLabel(endMethod);
        mv.visitLocalVariable("this", "L" + ABSTRACT_MONITOR_HANDLER + ";", null, l0, endMethod, 0);
        for (int i = 1; i <= paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i - 1];
            if (Integer.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "I", null, l0, endMethod, i + 1);
                continue;
            }
            if (Long.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "J", null, l0, endMethod, i + 1);
                continue;
            }
            if (Double.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "D", null, l0, endMethod, i + 1);
                continue;
            }
            if (Boolean.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "Z", null, l0, endMethod, i + 1);
                continue;
            }
            if (Float.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "F", null, l0, endMethod, i + 1);
                continue;
            }
            if (Short.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "S", null, l0, endMethod, i + 1);
                continue;
            }
            if (Byte.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "B", null, l0, endMethod, i + 1);
                continue;
            }
            if (Character.TYPE.equals(paramType)) {
                mv.visitLocalVariable("arg" + i, "C", null, l0, endMethod, i + 1);
                continue;
            }
            if (paramType.isPrimitive()) {
                throw new AssertionError((Object)"Unhandled type");
            }
            mv.visitLocalVariable("arg" + i, "Ljava/lang/Object;", null, l0, endMethod, i + 1);
        }
        mv.visitLocalVariable("entry", "L" + MONITOR_EVENT_ENTRY + ";", null, l0, endMethod, varEntryPosition);
        mv.visitLocalVariable("numberArgs", "I", null, l1, endMethod, varNumberArgsPosition);
        mv.visitLocalVariable("current", "L" + PARAM_ENTRY + ";", null, l2, endMethod, varParamEntryPosition);
        mv.visitLocalVariable("i", "I", null, l2, endMethod, varIPosition);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String calculateWriteParametersSignature(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        StringBuilder paramSignature = new StringBuilder("(");
        for (Class<?> paramType : paramTypes) {
            paramSignature.append(Type.getDescriptor(paramType));
        }
        paramSignature.append("L").append(MONITOR_EVENT_ENTRY).append(";)V");
        return paramSignature.toString();
    }

    private void writeConstructor(ClassWriter cw, String proxyClassDescriptor) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(56, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, ABSTRACT_MONITOR_HANDLER, "<init>", "()V");
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", proxyClassDescriptor, null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void pushInteger(int value, MethodVisitor mv) {
        if (value == 0) {
            mv.visitInsn(3);
        } else if (value == 1) {
            mv.visitInsn(4);
        } else if (value == 2) {
            mv.visitInsn(5);
        } else if (value == 3) {
            mv.visitInsn(6);
        } else if (value == 4) {
            mv.visitInsn(7);
        } else if (value == 5) {
            mv.visitInsn(8);
        } else {
            mv.visitIntInsn(16, value);
        }
    }

    private int calculateParameterSpace(Class<?>[] paramTypes) {
        int offset = 0;
        for (Class<?> paramType : paramTypes) {
            if (Double.TYPE.equals(paramType) || Long.TYPE.equals(paramType)) {
                offset += 2;
                continue;
            }
            ++offset;
        }
        return offset;
    }

    private BytecodeClassLoader getClassLoader(Class<?> type) {
        ClassLoader parent = type.getClassLoader();
        ClassLoader extensionClassLoader = this.getClass().getClassLoader();
        BytecodeClassLoader classLoader = new BytecodeClassLoader(URI.create("BytecodeClassLoader"), parent);
        classLoader.addParent(extensionClassLoader);
        return classLoader;
    }
}

