/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.api.MonitorChannel;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.monitor.impl.router.RingBufferDestinationRouter;
import org.fabric3.monitor.spi.event.MonitorEventEntry;
import org.fabric3.spi.monitor.DispatchInfo;

public class JDKMonitorHandler
implements InvocationHandler,
MonitorChannel {
    private RingBufferDestinationRouter router;
    private boolean asyncEnabled;
    private int destinationIndex;
    private Monitorable monitorable;
    private String source;
    private Map<Method, DispatchInfo> infos;
    private MonitorLevel level;
    private String template;

    public JDKMonitorHandler(int destinationIndex, Monitorable monitorable, RingBufferDestinationRouter router, Map<Method, DispatchInfo> infos, boolean asyncEnabled) {
        this.destinationIndex = destinationIndex;
        this.monitorable = monitorable;
        this.router = router;
        this.asyncEnabled = asyncEnabled;
        this.source = monitorable.getName();
        this.infos = infos;
        if (infos.size() == 1) {
            DispatchInfo info = infos.values().iterator().next();
            this.level = info.getLevel();
            this.template = info.getMessage();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String currentMessage;
        MonitorLevel currentLevel;
        if (args != null && args.length > 10) {
            throw new UnsupportedOperationException("Unsupported number of monitor arguments: " + args.length);
        }
        if (this.level != null) {
            currentLevel = this.level;
            currentMessage = this.template;
        } else {
            DispatchInfo info = this.infos.get(method);
            currentLevel = info.getLevel();
            currentMessage = info.getMessage();
        }
        if (currentLevel == null || currentLevel.intValue() < this.monitorable.getLevel().intValue()) {
            return null;
        }
        long timestamp = System.currentTimeMillis();
        if (this.asyncEnabled) {
            this.send(currentLevel, timestamp, currentMessage, args);
        } else {
            this.router.send(currentLevel, this.destinationIndex, timestamp, this.source, currentMessage, true, args);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(MonitorLevel level, long timestamp, String template, Object[] args) {
        MonitorEventEntry entry = null;
        try {
            long start = System.nanoTime();
            entry = this.router.get();
            entry.setDestinationIndex(this.destinationIndex);
            entry.setTimestampNanos(start);
            entry.setTemplate(template);
            entry.setParse(true);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    entry.getEntries()[i].setObjectValue(arg);
                }
            }
            entry.setLevel(level);
            entry.setLimit(args == null ? 0 : args.length);
            entry.setEntryTimestamp(timestamp);
        }
        finally {
            if (entry != null) {
                this.router.publish(entry);
            }
        }
    }

    @Override
    public void severe(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.SEVERE, message, args);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.WARNING, message, args);
    }

    @Override
    public void info(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.INFO, message, args);
    }

    @Override
    public void debug(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.DEBUG, message, args);
    }

    @Override
    public void trace(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.TRACE, message, args);
    }

    public void send(MonitorLevel level, long timestamp, String template, boolean parse, Object[] args) {
        if (args == null) {
            this.router.send(level, this.destinationIndex, timestamp, this.source, template, parse, template);
        } else {
            this.router.send(level, this.destinationIndex, timestamp, this.source, template, parse, args);
        }
    }

    private void checkAndSend(MonitorLevel level, String message, Object[] args) {
        if (level.intValue() < this.monitorable.getLevel().intValue()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.send(level, timestamp, message, true, args);
    }
}

