/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.fabric3.api.MonitorChannel;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.monitor.impl.proxy.AbstractMonitorProxyService;
import org.fabric3.monitor.impl.proxy.JDKMonitorHandler;
import org.fabric3.monitor.impl.router.RingBufferDestinationRouter;
import org.fabric3.spi.monitor.DispatchInfo;
import org.fabric3.spi.monitor.MonitorProxy;
import org.oasisopen.sca.annotation.Reference;

public class JDKRingBufferMonitorProxyService
extends AbstractMonitorProxyService {
    public JDKRingBufferMonitorProxyService(@Reference RingBufferDestinationRouter router, @Reference Monitorable monitorable) {
        super(router, monitorable);
    }

    @Override
    public <T> T createMonitor(Class<T> type, Monitorable monitorable, String destination) throws Fabric3Exception {
        if (destination == null) {
            destination = "default";
        }
        int destinationIndex = this.router.getDestinationIndex(destination);
        ClassLoader loader = type.getClassLoader();
        HashMap<Method, DispatchInfo> levels = new HashMap<Method, DispatchInfo>();
        for (Method method : type.getMethods()) {
            DispatchInfo info = this.createDispatchInfo(type, loader, method);
            levels.put(method, info);
        }
        JDKMonitorHandler handler = new JDKMonitorHandler(destinationIndex, monitorable, this.router, levels, this.enabled);
        if (MonitorChannel.class.isAssignableFrom(type) || MonitorProxy.class.isAssignableFrom(type)) {
            return type.cast(handler);
        }
        return type.cast(Proxy.newProxyInstance(loader, new Class[]{type}, (InvocationHandler)handler));
    }
}

