/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.proxy;

import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.monitor.MonitorProxyServiceExtension;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.monitor.impl.proxy.BytecodeMonitorProxyService;
import org.fabric3.monitor.impl.proxy.JDKRingBufferMonitorProxyService;
import org.fabric3.monitor.impl.router.RingBufferDestinationRouter;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class SwitchingMonitorProxyServiceExtension
implements MonitorProxyServiceExtension {
    public static final String ASYNCHRONOUS_MODE = "asynchronous";
    private RingBufferDestinationRouter router;
    private Monitorable monitorable;
    private boolean bytecodeGeneration;
    private boolean enabled = false;
    private MonitorProxyServiceExtension delegate;

    @Property(required=false)
    public void setProxy(String proxy) {
        this.bytecodeGeneration = "bytecode".equalsIgnoreCase(proxy);
    }

    @Property(required=false)
    public void setMode(String mode) {
        this.enabled = ASYNCHRONOUS_MODE.equalsIgnoreCase(mode);
    }

    public SwitchingMonitorProxyServiceExtension(@Reference RingBufferDestinationRouter router, @Reference Monitorable monitorable) {
        this.router = router;
        this.monitorable = monitorable;
    }

    @Init
    public void init() {
        if (this.bytecodeGeneration) {
            BytecodeMonitorProxyService byteCodeDelegate = new BytecodeMonitorProxyService(this.router, this.monitorable);
            byteCodeDelegate.setEnabled(this.enabled);
            this.delegate = byteCodeDelegate;
        } else {
            JDKRingBufferMonitorProxyService jdkDelegate = new JDKRingBufferMonitorProxyService(this.router, this.monitorable);
            jdkDelegate.setEnabled(this.enabled);
            this.delegate = jdkDelegate;
        }
    }

    @Override
    public <T> T createMonitor(Class<T> type) throws Fabric3Exception {
        return this.delegate.createMonitor(type);
    }

    @Override
    public <T> T createMonitor(Class<T> type, Monitorable monitorable, String destination) throws Fabric3Exception {
        return this.delegate.createMonitor(type, monitorable, destination);
    }
}

