/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.router;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.PhasedBackoffWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.monitor.impl.router.DestinationMonitor;
import org.fabric3.monitor.impl.router.MonitorEventEntryFactory;
import org.fabric3.monitor.impl.router.MonitorEventHandler;
import org.fabric3.monitor.impl.router.RingBufferDestinationRouter;
import org.fabric3.monitor.spi.destination.MonitorDestinationRegistry;
import org.fabric3.monitor.spi.event.MonitorEventEntry;
import org.fabric3.monitor.spi.event.ParameterEntry;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class RingBufferDestinationRouterImpl
implements RingBufferDestinationRouter {
    public static final String ASYNCHRONOUS_MODE = "asynchronous";
    private static final String SYNCHRONOUS_MODE = "synchronous";
    private ExecutorService executorService;
    private MonitorDestinationRegistry registry;
    private DestinationMonitor monitor;
    private Disruptor<MonitorEventEntry> disruptor;
    private int capacity = 1024;
    private int ringSize = 65536;
    private String strategyType = "blocking";
    private long blockingTimeoutNanos = 1000L;
    private long spinTimeoutNanos = 1000L;
    private long yieldTimeoutNanos = 1000L;
    private String phasedBlockingType = "lock";
    private boolean enabled = false;

    public RingBufferDestinationRouterImpl(@Reference(name="executorService") ExecutorService executorService, @Reference MonitorDestinationRegistry registry, @Monitor DestinationMonitor monitor) {
        this.executorService = executorService;
        this.registry = registry;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Property(required=false)
    public void setRingSize(int ringSize) {
        this.ringSize = ringSize;
    }

    @Property(required=false)
    public void setMode(String mode) {
        if (ASYNCHRONOUS_MODE.equalsIgnoreCase(mode)) {
            this.enabled = true;
        } else if (SYNCHRONOUS_MODE.equalsIgnoreCase(mode)) {
            this.enabled = false;
        } else {
            this.enabled = false;
            this.monitor.unknownMode(mode);
        }
    }

    @Property(required=false)
    public void setBlockingTimeoutNanos(long blockingTimeoutNanos) {
        this.blockingTimeoutNanos = blockingTimeoutNanos;
    }

    @Property(required=false)
    public void setPhasedBlockingType(String type) {
        this.phasedBlockingType = type;
    }

    @Property(required=false)
    public void setWaitStrategy(String strategy) {
        this.strategyType = strategy;
    }

    @Property(required=false)
    public void setSpinTimeoutNanos(long timeout) {
        this.spinTimeoutNanos = timeout;
    }

    @Property(required=false)
    public void setYieldTimeoutNanos(long timeout) {
        this.yieldTimeoutNanos = timeout;
    }

    @Init
    public void init() throws FileNotFoundException {
        if (!this.enabled) {
            return;
        }
        WaitStrategy waitStrategy = this.createWaitStrategy();
        MonitorEventEntryFactory factory = new MonitorEventEntryFactory(this.capacity);
        this.disruptor = new Disruptor<MonitorEventEntry>(factory, this.ringSize, this.executorService, ProducerType.MULTI, waitStrategy);
        MonitorEventHandler handler = new MonitorEventHandler(this.registry);
        this.disruptor.handleEventsWith(handler);
        this.disruptor.start();
    }

    @Destroy
    public void destroy() throws IOException {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        }
    }

    @Override
    public int getDestinationIndex(String name) {
        return this.registry.getIndex(name);
    }

    @Override
    public MonitorEventEntry get() {
        RingBuffer<MonitorEventEntry> ringBuffer = this.disruptor.getRingBuffer();
        long sequence = ringBuffer.next();
        MonitorEventEntry entry = ringBuffer.get(sequence);
        entry.getBuffer().clear();
        for (ParameterEntry parameterEntry : entry.getEntries()) {
            parameterEntry.reset();
        }
        entry.setSequence(sequence);
        return entry;
    }

    @Override
    public void publish(MonitorEventEntry entry) {
        this.disruptor.getRingBuffer().publish(entry.getSequence());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(MonitorLevel level, int destinationIndex, long timestamp, String source, String template, boolean parse, Object ... args) {
        if (this.enabled) {
            MonitorEventEntry entry = null;
            try {
                entry = this.get();
                entry.setDestinationIndex(destinationIndex);
                entry.setTimestampNanos(System.nanoTime());
                entry.setLevel(level);
                entry.setEntryTimestamp(timestamp);
                entry.setTemplate(template);
                entry.setParse(parse);
                entry.setLimit(args == null ? 0 : args.length);
                if (args == null) return;
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    entry.getEntries()[i].setObjectValue(arg);
                }
                return;
            }
            finally {
                if (entry != null) {
                    this.publish(entry);
                }
            }
        }
        try {
            this.registry.write(destinationIndex, level, timestamp, source, template, args);
            return;
        }
        catch (IOException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    private WaitStrategy createWaitStrategy() {
        WaitStrategy waitStrategy;
        if ("blocking".equalsIgnoreCase(this.strategyType)) {
            waitStrategy = new BlockingWaitStrategy();
            this.monitor.blockingStrategy();
        } else if ("yielding".equalsIgnoreCase(this.strategyType)) {
            waitStrategy = new YieldingWaitStrategy();
            this.monitor.yieldingStrategy();
        } else if ("sleeping".equalsIgnoreCase(this.strategyType)) {
            waitStrategy = new SleepingWaitStrategy();
            this.monitor.sleepingStrategy();
        } else if ("backoff".equalsIgnoreCase(this.strategyType)) {
            if ("lock".equalsIgnoreCase(this.phasedBlockingType)) {
                waitStrategy = PhasedBackoffWaitStrategy.withLock(this.spinTimeoutNanos, this.yieldTimeoutNanos, TimeUnit.NANOSECONDS);
                this.monitor.phasedBackoffWithLockStrategy(this.spinTimeoutNanos, this.yieldTimeoutNanos);
            } else {
                waitStrategy = PhasedBackoffWaitStrategy.withSleep(this.spinTimeoutNanos, this.yieldTimeoutNanos, TimeUnit.NANOSECONDS);
                this.monitor.phasedBackoffWithSleepStrategy(this.spinTimeoutNanos, this.yieldTimeoutNanos);
            }
        } else if ("spin".equalsIgnoreCase(this.strategyType)) {
            waitStrategy = new BusySpinWaitStrategy();
            this.monitor.busySpinStrategy();
        } else if ("timeout".equalsIgnoreCase(this.strategyType)) {
            waitStrategy = new TimeoutBlockingWaitStrategy(this.blockingTimeoutNanos, TimeUnit.NANOSECONDS);
            this.monitor.timeoutStrategy(this.blockingTimeoutNanos);
        } else {
            waitStrategy = new BlockingWaitStrategy();
            this.monitor.invalidStrategy(this.strategyType);
        }
        return waitStrategy;
    }
}

