/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import java.util.Arrays;
import org.fabric3.monitor.impl.writer.LongWriter;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public abstract class AbstractNumericWriter {
    protected static final int[] DIGITS;
    protected static final int[] POWER_5;
    protected static final int[] POW_10;
    protected static final byte[] NAN;
    protected static final byte[] INFINITY;
    protected static final byte[] NEGATIVE_INFINITY;
    protected static final double EXPONENT_FACTOR = 3.321928094887362;
    protected static final int BUFFER_SIZE = 20;
    protected static final byte[] ZERO_ZERO;
    protected static final byte[] POINT_ZERO;
    protected static final byte[] ZERO_POINT;
    protected static final ThreadLocal<char[]> CHAR_BUFFER;
    protected static final int BUFFER_LENGTH = 81;
    protected static final ThreadLocal<int[]> BUFFER;

    protected static long getDecimalMantissa(long binaryMantissa, int binaryExponent, int decimalExponent) {
        if (binaryMantissa < 0L) {
            throw new IllegalArgumentException("Binary mantissa (" + binaryMantissa + ") < 0");
        }
        if (binaryExponent < -1075) {
            throw new IllegalArgumentException("Binary exponent (" + binaryExponent + ") < -1075");
        }
        if (binaryExponent > 1075) {
            throw new IllegalArgumentException("Binary exponent (" + binaryExponent + ") > 1075");
        }
        if (binaryExponent == 0) {
            return AbstractNumericWriter.getDecimalMantissa0(binaryMantissa, decimalExponent);
        }
        if (binaryExponent > 0) {
            return AbstractNumericWriter.getDecimalMantissaPlus(binaryMantissa, binaryExponent, decimalExponent);
        }
        return AbstractNumericWriter.getDecimalMantissaMinus(binaryMantissa, binaryExponent, decimalExponent);
    }

    private static long getDecimalMantissa0(long binaryMantissa, int decimalExponent) {
        if (binaryMantissa < 0L) {
            throw new IllegalArgumentException("Binary mantissa (" + binaryMantissa + ") < 0");
        }
        if (decimalExponent == 0) {
            return binaryMantissa;
        }
        if (decimalExponent > 0) {
            long result = binaryMantissa;
            for (int i = 0; i < decimalExponent; ++i) {
                result /= 10L;
            }
            return result;
        }
        long result = binaryMantissa;
        for (int i = 0; i > decimalExponent; --i) {
            result *= 10L;
        }
        return result;
    }

    private static long getDecimalMantissaPlus(long binaryMantissa, int binaryExponent, int decimalExponent) {
        int l;
        if (binaryMantissa < 0L) {
            throw new IllegalArgumentException("Binary mantissa (" + binaryMantissa + ") < 0");
        }
        if (binaryExponent <= 0) {
            throw new IllegalArgumentException("Binary exponent (" + binaryExponent + ") <= 0");
        }
        if (binaryExponent > 1075) {
            throw new IllegalArgumentException("Binary exponent (" + binaryExponent + ") > 1075");
        }
        int[] buffer = BUFFER.get();
        int pos = binaryExponent / 32;
        int offset = binaryExponent % 32;
        if (offset > 0) {
            buffer[pos + 2] = (int)(binaryMantissa >>> 64 - offset);
            l = pos + 3;
        } else {
            l = pos + 2;
        }
        buffer[pos + 1] = (int)(binaryMantissa >>> 32 - offset);
        buffer[pos] = (int)(binaryMantissa << offset);
        Arrays.fill(buffer, 0, pos, 0);
        return AbstractNumericWriter.normalizeDecimalMantissa(buffer, l, decimalExponent);
    }

    private static long getDecimalMantissaMinus(long binaryMantissa, int binaryExponent, int decimalExponent) {
        int be;
        if (binaryMantissa < 0L) {
            throw new IllegalArgumentException("Binary mantissa (" + binaryMantissa + ") < 0");
        }
        if (binaryExponent < -1075) {
            throw new IllegalArgumentException("Binary exponent (" + binaryExponent + ") < -1075");
        }
        if (binaryExponent >= 0) {
            throw new IllegalArgumentException("Binary exponent (" + binaryExponent + ") >= 0");
        }
        for (be = binaryExponent; binaryMantissa <= 0x1999999999999999L && be < 0; binaryMantissa *= 5L, ++be) {
        }
        int[] buffer = BUFFER.get();
        buffer[0] = (int)binaryMantissa;
        buffer[1] = (int)(binaryMantissa >>> 32);
        int l = AbstractNumericWriter.multiplyByPower5(buffer, buffer[1] == 0 ? 1 : 2, -be);
        return AbstractNumericWriter.normalizeDecimalMantissa(buffer, l, decimalExponent - binaryExponent);
    }

    private static int multiplyByPower5(int[] buffer, int length, int power) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") < 0");
        }
        if (power < 0) {
            throw new IllegalArgumentException("Power (" + power + ")< 0");
        }
        int maxStep = POWER_5.length - 1;
        while (power > 0) {
            int step = Math.min(power, maxStep);
            int k = POWER_5[step];
            int carry = 0;
            for (int j = 0; j < length; ++j) {
                long chunk = ((long)buffer[j] & 0xFFFFFFFFL) * (long)k + ((long)carry & 0xFFFFFFFFL);
                buffer[j] = (int)chunk;
                carry = (int)(chunk >>> 32);
            }
            if (carry != 0) {
                buffer[length++] = carry;
            }
            power -= step;
        }
        return length;
    }

    private static long normalizeDecimalMantissa(int[] buffer, int length, int decimalExponent) {
        long result;
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") < 0");
        }
        int bufferLength = buffer.length;
        if (length > buffer.length) {
            throw new IllegalArgumentException("Length (" + length + ") > buffer length (" + bufferLength + ")");
        }
        if (decimalExponent >= 0) {
            length = AbstractNumericWriter.shiftRight(buffer, length, decimalExponent);
            return AbstractNumericWriter.divideByPower5(buffer, length, decimalExponent);
        }
        if (length == 0) {
            result = 0L;
        } else if (length == 1) {
            result = (long)buffer[0] & 0xFFFFFFFFL;
        } else if (length == 2) {
            result = (long)buffer[1] << 32 | (long)buffer[0] & 0xFFFFFFFFL;
        } else {
            throw new Error("Mantissa does not fit into long");
        }
        for (int i = 0; i > decimalExponent; --i) {
            result *= 10L;
        }
        return result;
    }

    private static int shiftRight(int[] buffer, int length, int n) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") < 0");
        }
        if (n < 0) {
            throw new IllegalArgumentException("N (" + n + ") is null");
        }
        int bufferLength = buffer.length;
        if (length > bufferLength) {
            throw new IllegalArgumentException("Length (" + length + ") > buffer lenght (" + bufferLength + ")");
        }
        if (n >= length * 32) {
            length = 0;
        } else if (n > 0) {
            int offset = n / 32;
            int bitOffset = n % 32;
            if (bitOffset == 0) {
                System.arraycopy(buffer, offset, buffer, 0, length -= offset);
            } else {
                int l1 = (length -= offset) - 1;
                for (int i = 0; i < l1; ++i) {
                    buffer[i] = buffer[i + offset] >>> bitOffset | buffer[i + offset + 1] << 32 - bitOffset;
                }
                buffer[l1] = buffer[l1 + offset] >>> bitOffset;
            }
        }
        while (length > 0 && buffer[length - 1] == 0) {
            --length;
        }
        return length;
    }

    private static long divideByPower5(int[] buffer, int length, int power) {
        long result;
        int maxStep = POWER_5.length - 1;
        while (power > 0 && (length > 2 || length == 2 && (long)buffer[1] < 0L)) {
            int step = Math.min(power, maxStep);
            int k = POWER_5[step];
            int carry = 0;
            for (int j = length - 1; j >= 0; --j) {
                int v;
                long chunk = ((long)carry << 32) + ((long)buffer[j] & 0xFFFFFFFFL);
                buffer[j] = v = (int)(chunk / (long)k);
                carry = (int)(chunk - (long)v * (long)k);
                if (v != 0 || j != length - 1) continue;
                --length;
            }
            power -= step;
        }
        if (length == 0) {
            result = 0L;
        } else if (length == 1) {
            result = (long)buffer[0] & 0xFFFFFFFFL;
        } else if (length == 2) {
            result = (long)buffer[1] << 32 | (long)buffer[0] & 0xFFFFFFFFL;
        } else {
            throw new IllegalArgumentException("Result does not fit into long");
        }
        while (power > 0 && result != 0L) {
            int step = Math.min(power, maxStep);
            int k = POWER_5[step];
            result /= (long)k;
            power -= step;
        }
        return result;
    }

    protected static int formatSimple(boolean negative, long decimalMantissa, int decimalExponent, ResizableByteBuffer buffer) {
        int written = 0;
        if (decimalMantissa < 0L) {
            throw new IllegalArgumentException("Decimal mantissa (" + decimalMantissa + ") < 0");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Output is null");
        }
        if (negative) {
            buffer.put(45);
            ++written;
        }
        if (decimalMantissa == 0L) {
            buffer.put(ZERO_ZERO);
            written += 3;
        } else if (decimalExponent >= 0) {
            written += LongWriter.write(decimalMantissa, buffer);
            written += AbstractNumericWriter.writeCharacterNTimes('0', decimalExponent, buffer);
            buffer.put(POINT_ZERO);
            written += 2;
        } else {
            char[] charBuffer = CHAR_BUFFER.get();
            int pos = AbstractNumericWriter.getChars(decimalMantissa, charBuffer);
            int afterLastDigitPos = 20;
            int i = 19;
            while (charBuffer[i] == '0') {
                afterLastDigitPos = i--;
            }
            int n = 20 - pos;
            if (n <= -decimalExponent) {
                buffer.put(ZERO_POINT);
                buffer.put(ZERO_POINT);
                ++written;
                ++written;
                written += AbstractNumericWriter.writeCharacterNTimes('0', -decimalExponent - n, buffer);
                written += AbstractNumericWriter.write(charBuffer, pos, afterLastDigitPos - pos, buffer);
            } else {
                int digitsBeforeDot = n + decimalExponent;
                int digitsAfterDot = afterLastDigitPos - pos - digitsBeforeDot;
                written += AbstractNumericWriter.write(charBuffer, pos, digitsBeforeDot, buffer);
                buffer.put(46);
                ++written;
                if (digitsAfterDot > 0) {
                    written += AbstractNumericWriter.write(charBuffer, pos + digitsBeforeDot, digitsAfterDot, buffer);
                } else {
                    buffer.put(48);
                    ++written;
                }
            }
        }
        return written;
    }

    private static int write(char[] chars, int pos, int length, ResizableByteBuffer buffer) {
        int written = 0;
        int amount = pos + length;
        for (int i = pos; i < amount; ++i) {
            buffer.put((byte)chars[i]);
            ++written;
        }
        return written;
    }

    private static int writeCharacterNTimes(char ch, int n, ResizableByteBuffer buffer) {
        if (n < 0) {
            throw new IllegalArgumentException("N < 0");
        }
        int written = 0;
        block5: while (n > 0) {
            switch (n) {
                case 1: {
                    buffer.put((byte)ch);
                    ++written;
                    --n;
                    continue block5;
                }
                case 2: {
                    buffer.put((byte)ch);
                    buffer.put((byte)ch);
                    written += 2;
                    n -= 2;
                    continue block5;
                }
                case 3: {
                    buffer.put((byte)ch);
                    buffer.put((byte)ch);
                    buffer.put((byte)ch);
                    written += 3;
                    n -= 3;
                    continue block5;
                }
            }
            buffer.put((byte)ch);
            buffer.put((byte)ch);
            buffer.put((byte)ch);
            buffer.put((byte)ch);
            written += 4;
            n -= 4;
        }
        return written;
    }

    private static int getChars(long value, char[] buffer) {
        int d4;
        int d;
        if (value < 0L) {
            throw new IllegalArgumentException("Value (" + value + ") < 0");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        int pos = 20;
        while (value > Integer.MAX_VALUE) {
            long v = value / 10000L;
            d = (int)(value - v * 10000L);
            value = v;
            d4 = DIGITS[d];
            buffer[--pos] = (char)(d4 >>> 0 & 0xFF);
            buffer[--pos] = (char)(d4 >>> 8 & 0xFF);
            buffer[--pos] = (char)(d4 >>> 16 & 0xFF);
            buffer[--pos] = (char)(d4 >>> 24 & 0xFF);
        }
        int intValue = (int)value;
        while (intValue >= 10000) {
            int v = intValue / 10000;
            d = intValue - v * 10000;
            intValue = v;
            d4 = DIGITS[d];
            buffer[--pos] = (char)(d4 >>> 0 & 0xFF);
            buffer[--pos] = (char)(d4 >>> 8 & 0xFF);
            buffer[--pos] = (char)(d4 >>> 16 & 0xFF);
            buffer[--pos] = (char)(d4 >>> 24 & 0xFF);
        }
        int d42 = DIGITS[intValue];
        if (intValue >= 1) {
            buffer[--pos] = (char)(d42 >>> 0 & 0xFF);
        }
        if (intValue >= 10) {
            buffer[--pos] = (char)(d42 >>> 8 & 0xFF);
        }
        if (intValue >= 100) {
            buffer[--pos] = (char)(d42 >>> 16 & 0xFF);
        }
        if (intValue >= 1000) {
            buffer[--pos] = (char)(d42 >>> 24 & 0xFF);
        }
        return pos;
    }

    static {
        int i;
        DIGITS = new int[10000];
        for (i = 0; i < 10000; ++i) {
            AbstractNumericWriter.DIGITS[i] = (48 + i / 1000 % 10 << 24) + (48 + i / 100 % 10 << 16) + (48 + i / 10 % 10 << 8) + (48 + i / 1 % 10 << 0);
        }
        POWER_5 = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        POW_10 = new int[258];
        for (i = 0; i < 258; ++i) {
            AbstractNumericWriter.POW_10[i] = (int)Math.pow(10.0, Math.scalb(i, -8));
        }
        NAN = "NaN".getBytes();
        INFINITY = "Infinity".getBytes();
        NEGATIVE_INFINITY = "-Infinity".getBytes();
        ZERO_ZERO = "0.0".getBytes();
        POINT_ZERO = ".0".getBytes();
        ZERO_POINT = "0.".getBytes();
        CHAR_BUFFER = new ThreadLocal<char[]>(){

            @Override
            protected char[] initialValue() {
                return new char[20];
            }
        };
        BUFFER = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return new int[81];
            }
        };
    }
}

