/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import org.fabric3.monitor.impl.writer.AbstractNumericWriter;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public class DoubleWriter
extends AbstractNumericWriter {
    public static int write(double value, ResizableByteBuffer buffer) {
        int written = 0;
        if (Double.isNaN(value)) {
            buffer.put(NAN);
            written += 3;
        } else if (Double.isInfinite(value)) {
            if (value > 0.0) {
                buffer.put(INFINITY);
                written += INFINITY.length;
            } else {
                buffer.put(NEGATIVE_INFINITY);
                written += NEGATIVE_INFINITY.length;
            }
        } else {
            long bits = Double.doubleToRawLongBits(value);
            boolean negative = bits >>> 63 != 0L;
            int binaryExponent = (int)(bits >>> 52 & 0x7FFL) - 1075;
            long binaryMantissa = bits & 0xFFFFFFFFFFFFFL;
            if (binaryExponent == -1075) {
                binaryExponent = -1074;
            } else {
                binaryMantissa += 0x10000000000000L;
            }
            double significantDigits = (double)(binaryExponent - 1) / 3.321928094887362;
            int decimalExponent = (int)Math.floor(significantDigits);
            int margin = POW_10[(int)Math.scalb(significantDigits - (double)decimalExponent, 8)];
            long decimalMantissa = DoubleWriter.getDecimalMantissa(binaryMantissa, binaryExponent, decimalExponent);
            int lastDigit = (int)(decimalMantissa % 10L);
            if (lastDigit <= margin) {
                decimalMantissa /= 10L;
                ++decimalExponent;
            } else if (lastDigit >= 10 - margin) {
                decimalMantissa = decimalMantissa / 10L + 1L;
                ++decimalExponent;
            }
            written += DoubleWriter.formatSimple(negative, decimalMantissa, decimalMantissa == 0L ? 0 : decimalExponent, buffer);
        }
        return written;
    }
}

